/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.lang.invoke.MethodHandles;
import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo26_1_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("26.1.0");
    private static final Logger LOG = Logger.getLogger(MethodHandles.lookup().lookupClass());

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    private void migrateRealm(KeycloakSession session, RealmModel realm) {
        MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        migrationProvider.addOIDCServiceAccountClientScope(realm);
        session.authenticationSessions().migrate(VERSION.toString());
    }
}

