/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.servlet.Servlet;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.jboss.logging.Logger;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServletReregistrationService {
    private static final String CXF_SERVLET_PREFIX = "org.apache.cxf.servlet.";
    protected static final Logger log = Logger.getLogger(ServletReregistrationService.class);
    private static final List<String> FILTERED_PROPERTIES = Arrays.asList("objectClass", "service.id");
    private BundleContext bundleContext;
    private ServiceReference managedServiceReference;
    private ServiceTracker webContainerTracker;
    private String alias;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void start() {
        WebContainer externalWebContainer;
        if (this.managedServiceReference == null) {
            return;
        }
        Dictionary properties = this.obtainProperties();
        this.alias = (String)this.getProp(properties, "org.apache.cxf.servlet.context", "/cxf");
        if (this.alias == null) {
            this.alias = "/cxf";
        }
        if ((externalWebContainer = this.findExternalWebContainer()) == null) {
            return;
        }
        try {
            externalWebContainer.unregister(this.alias);
            log.debug((Object)("Original servlet with alias " + this.getAlias() + " unregistered successfully from external web container."));
        }
        catch (IllegalStateException e) {
            log.warn((Object)("Can't unregister servlet due to: " + e.getMessage()));
        }
        final Dictionary finalProperties = properties;
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference webContainerServiceReference) {
                WebContainer ourWebContainer = (WebContainer)ServletReregistrationService.this.bundleContext.getService(webContainerServiceReference);
                ServletReregistrationService.this.registerServlet(ourWebContainer, finalProperties);
                log.debugv("Servlet with alias " + ServletReregistrationService.this.getAlias() + " registered to secured web container", new Object[0]);
                return ourWebContainer;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference webContainerServiceReference, Object service) {
                WebContainer ourWebContainer = (WebContainer)ServletReregistrationService.this.bundleContext.getService(webContainerServiceReference);
                String alias = ServletReregistrationService.this.getAlias();
                ourWebContainer.unregister(alias);
                log.debug((Object)("Servlet with alias " + ServletReregistrationService.this.getAlias() + " unregistered from secured web container"));
            }
        };
        this.webContainerTracker = new ServiceTracker(this.bundleContext, WebContainer.class.getName(), trackerCustomizer);
        this.webContainerTracker.open();
    }

    public void stop() {
        this.webContainerTracker.remove(this.webContainerTracker.getServiceReference());
        WebContainer externalWebContainer = this.findExternalWebContainer();
        this.registerServlet(externalWebContainer, this.obtainProperties());
        log.debug((Object)("Servlet with alias " + this.getAlias() + " registered back to external web container"));
    }

    private String getAlias() {
        return this.alias;
    }

    protected void registerServlet(WebContainer webContainer, Dictionary properties) {
        HttpContext httpContext = webContainer.createDefaultHttpContext();
        ServiceReference destinationServiceServiceReference = this.bundleContext.getServiceReference("org.apache.cxf.transport.http.DestinationRegistry");
        DestinationRegistry destinationRegistry = (DestinationRegistry)this.bundleContext.getService(destinationServiceServiceReference);
        CXFNonSpringServlet servlet = new CXFNonSpringServlet(destinationRegistry, false);
        try {
            if (properties == null) {
                properties = new Properties();
            }
            Properties sprops = new Properties();
            sprops.put("init-prefix", this.getProp(properties, "org.apache.cxf.servlet.init-prefix", ""));
            sprops.put("servlet-name", this.getProp(properties, "org.apache.cxf.servlet.name", "cxf-osgi-transport-servlet"));
            sprops.put("hide-service-list-page", this.getProp(properties, "org.apache.cxf.servlet.hide-service-list-page", "false"));
            sprops.put("disable-address-updates", this.getProp(properties, "org.apache.cxf.servlet.disable-address-updates", "true"));
            sprops.put("base-address", this.getProp(properties, "org.apache.cxf.servlet.base-address", ""));
            sprops.put("service-list-path", this.getProp(properties, "org.apache.cxf.servlet.service-list-path", ""));
            sprops.put("static-resources-list", this.getProp(properties, "org.apache.cxf.servlet.static-resources-list", ""));
            sprops.put("redirects-list", this.getProp(properties, "org.apache.cxf.servlet.redirects-list", ""));
            sprops.put("redirect-servlet-name", this.getProp(properties, "org.apache.cxf.servlet.redirect-servlet-name", ""));
            sprops.put("redirect-servlet-path", this.getProp(properties, "org.apache.cxf.servlet.redirect-servlet-path", ""));
            sprops.put("service-list-all-contexts", this.getProp(properties, "org.apache.cxf.servlet.service-list-all-contexts", ""));
            sprops.put("service-list-page-authenticate", this.getProp(properties, "org.apache.cxf.servlet.service-list-page-authenticate", "false"));
            sprops.put("service-list-page-authenticate-realm", this.getProp(properties, "org.apache.cxf.servlet.service-list-page-authenticate-realm", "karaf"));
            sprops.put("use-x-forwarded-headers", this.getProp(properties, "org.apache.cxf.servlet.use-x-forwarded-headers", "false"));
            if (Boolean.valueOf(this.getProp(properties, "org.apache.cxf.servlet.support.extra.properties", "true").toString()).booleanValue()) {
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String nextKey = keys.nextElement().toString();
                    if (nextKey.startsWith(CXF_SERVLET_PREFIX)) continue;
                    sprops.put(nextKey, properties.get(nextKey));
                }
            }
            Hashtable<String, String> servletInitParams = new Hashtable<String, String>();
            Enumeration<Object> keys = sprops.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (FILTERED_PROPERTIES.contains(propName)) continue;
                servletInitParams.put(propName, sprops.getProperty(propName));
            }
            webContainer.registerServlet(this.alias, (Servlet)servlet, servletInitParams, httpContext);
        }
        catch (Exception e) {
            log.error((Object)"Can't register servlet in web container", (Throwable)e);
        }
    }

    protected WebContainer findExternalWebContainer() {
        BundleContext servletBundleContext = this.managedServiceReference.getBundle().getBundleContext();
        ServiceReference webContainerReference = servletBundleContext.getServiceReference(WebContainer.class.getName());
        if (webContainerReference == null) {
            log.warn((Object)("Not found webContainer reference for bundle " + servletBundleContext));
            return null;
        }
        return (WebContainer)servletBundleContext.getService(webContainerReference);
    }

    private Dictionary obtainProperties() {
        Dictionary properties = null;
        ServiceReference reference = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        ConfigurationAdmin admin = (ConfigurationAdmin)this.bundleContext.getService(reference);
        try {
            Configuration configuration = admin.getConfiguration("org.apache.cxf.osgi");
            properties = configuration.getProperties();
        }
        catch (Exception e) {
            log.warn((Object)"Unable to obtain cxf osgi configadmin reference.", (Throwable)e);
        }
        return properties;
    }

    private Object getProp(Dictionary properties, String key, Object defaultValue) {
        Object value = null;
        if (properties != null) {
            value = properties.get(key);
        }
        return value == null ? defaultValue : value;
    }

    public ServiceReference getManagedServiceReference() {
        return this.managedServiceReference;
    }

    public void setManagedServiceReference(ServiceReference managedServiceReference) {
        this.managedServiceReference = managedServiceReference;
    }
}

