import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import styles from "../../@patternfly/patternfly/components/Nav/nav.css.js";
import { css } from '@patternfly/react-styles';
import { NavContext } from './Nav';
export var NavItem = function NavItem(_ref) {
  var _ref$children = _ref.children,
      children = _ref$children === void 0 ? null : _ref$children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$to = _ref.to,
      to = _ref$to === void 0 ? '' : _ref$to,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$groupId = _ref.groupId,
      groupId = _ref$groupId === void 0 ? null : _ref$groupId,
      _ref$itemId = _ref.itemId,
      itemId = _ref$itemId === void 0 ? null : _ref$itemId,
      _ref$preventDefault = _ref.preventDefault,
      preventDefault = _ref$preventDefault === void 0 ? false : _ref$preventDefault,
      _ref$onClick = _ref.onClick,
      _onClick = _ref$onClick === void 0 ? null : _ref$onClick,
      props = _objectWithoutProperties(_ref, ["children", "className", "to", "isActive", "groupId", "itemId", "preventDefault", "onClick"]);

  var renderDefaultLink = function renderDefaultLink() {
    var preventLinkDefault = preventDefault || !to;
    return React.createElement(NavContext.Consumer, null, function (context) {
      return React.createElement("a", _extends({
        href: to,
        onClick: function onClick(e) {
          return context.onSelect(e, groupId, itemId, to, preventLinkDefault, _onClick);
        },
        className: css(styles.navLink, isActive && styles.modifiers.current, className),
        "aria-current": isActive ? 'page' : null
      }, props), children);
    });
  };

  var renderClonedChild = function renderClonedChild(child) {
    return React.createElement(NavContext.Consumer, null, function (context) {
      return React.cloneElement(child, {
        onClick: function onClick(e) {
          return context.onSelect(e, groupId, itemId, to, preventDefault, _onClick);
        },
        className: css(styles.navLink, isActive && styles.modifiers.current, className),
        'aria-current': isActive ? 'page' : null
      });
    });
  };

  return React.createElement("li", {
    className: css(styles.navItem, className)
  }, React.isValidElement(children) ? renderClonedChild(children) : renderDefaultLink());
};
NavItem.propTypes = {
  children: _pt.node,
  className: _pt.string,
  to: _pt.string,
  isActive: _pt.bool,
  groupId: _pt.oneOfType([_pt.string, _pt.number, _pt.oneOf([null])]),
  itemId: _pt.oneOfType([_pt.string, _pt.number, _pt.oneOf([null])]),
  preventDefault: _pt.bool,
  onClick: _pt.func
};