import * as React from 'react';
export interface ModalContentProps {
    /** Content rendered inside the Modal. */
    children: React.ReactNode;
    /** Additional classes added to the button */
    className?: string;
    /** Creates a large version of the Modal */
    isLarge?: boolean;
    /** Creates a small version of the Modal */
    isSmall?: boolean;
    /** Flag to show the modal */
    isOpen?: boolean;
    /** Content of the Modal Header */
    title: string;
    /** Flag to show the title */
    hideTitle?: boolean;
    /** Default width of the content. */
    width?: number | string;
    /** Content of the Modal Footer */
    actions?: any;
    /** A callback for when the close button is clicked */
    onClose?: () => void;
    /** Id to use for Modal Box description */
    ariaDescribedById?: string;
    /** Id of the ModalBoxBody */
    id: string;
}
export declare const ModalContent: React.FunctionComponent<ModalContentProps>;
