import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import styles from "../../@patternfly/patternfly/components/Expandable/expandable.css.js";
import { css } from '@patternfly/react-styles';
import { AngleRightIcon } from '@patternfly/react-icons';
export var Expandable = function Expandable(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      children = _ref.children,
      _ref$isExpanded = _ref.isExpanded,
      isExpanded = _ref$isExpanded === void 0 ? false : _ref$isExpanded,
      _ref$toggleText = _ref.toggleText,
      toggleText = _ref$toggleText === void 0 ? '' : _ref$toggleText,
      _ref$onToggle = _ref.onToggle,
      onToggle = _ref$onToggle === void 0 ? function () {
    return undefined;
  } : _ref$onToggle,
      _ref$isFocused = _ref.isFocused,
      isFocused = _ref$isFocused === void 0 ? false : _ref$isFocused,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$isHovered = _ref.isHovered,
      isHovered = _ref$isHovered === void 0 ? false : _ref$isHovered,
      props = _objectWithoutProperties(_ref, ["className", "children", "isExpanded", "toggleText", "onToggle", "isFocused", "isActive", "isHovered"]);

  return React.createElement("div", _extends({}, props, {
    className: css(styles.expandable, isExpanded && styles.modifiers.expanded, className)
  }), React.createElement("button", {
    className: css(styles.expandableToggle, isFocused && styles.modifiers.focus, isHovered && styles.modifiers.hover, isActive && styles.modifiers.active),
    "aria-expanded": isExpanded,
    onClick: onToggle
  }, React.createElement(AngleRightIcon, {
    className: css(styles.expandableToggleIcon),
    "aria-hidden": true
  }), React.createElement("span", null, toggleText)), React.createElement("div", {
    className: css(styles.expandableContent),
    hidden: !isExpanded
  }, children));
};
Expandable.propTypes = {
  children: _pt.node.isRequired,
  className: _pt.string,
  isExpanded: _pt.bool,
  toggleText: _pt.string,
  onToggle: _pt.func,
  isFocused: _pt.bool,
  isHovered: _pt.bool,
  isActive: _pt.bool
};