"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Alert = exports.AlertVariant = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _reactStyles = require("@patternfly/react-styles");

var _alertCss = _interopRequireDefault(require("../../@patternfly/patternfly/components/Alert/alert.css.js"));

var _accessibilityCss = _interopRequireDefault(require("../../@patternfly/patternfly/utilities/Accessibility/accessibility.css.js"));

var _AlertIcon = require("./AlertIcon");

var _util = require("../../helpers/util");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var AlertVariant;
exports.AlertVariant = AlertVariant;

(function (AlertVariant) {
  AlertVariant["success"] = "success";
  AlertVariant["danger"] = "danger";
  AlertVariant["warning"] = "warning";
  AlertVariant["info"] = "info";
})(AlertVariant || (exports.AlertVariant = AlertVariant = {}));

;

var Alert = function Alert(_ref) {
  var variant = _ref.variant,
      _ref$variantLabel = _ref.variantLabel,
      variantLabel = _ref$variantLabel === void 0 ? "".concat((0, _util.capitalize)(variant), " alert:") : _ref$variantLabel,
      _ref$ariaLabel = _ref['aria-label'],
      ariaLabel = _ref$ariaLabel === void 0 ? "".concat((0, _util.capitalize)(variant), " Alert") : _ref$ariaLabel,
      _ref$action = _ref.action,
      action = _ref$action === void 0 ? null : _ref$action,
      title = _ref.title,
      _ref$children = _ref.children,
      children = _ref$children === void 0 ? '' : _ref$children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      props = _objectWithoutProperties(_ref, ["variant", "variantLabel", "aria-label", "action", "title", "children", "className"]);

  var readerTitle = React.createElement(React.Fragment, null, React.createElement("span", {
    className: (0, _reactStyles.css)(_accessibilityCss["default"].screenReader)
  }, variantLabel), title);
  var customClassName = (0, _reactStyles.css)(_alertCss["default"].alert, (0, _reactStyles.getModifier)(_alertCss["default"], variant, _alertCss["default"].modifiers.info), className);
  return React.createElement("div", _extends({}, props, {
    className: customClassName,
    "aria-label": ariaLabel
  }), React.createElement(_AlertIcon.AlertIcon, {
    variant: variant
  }), React.createElement("h4", {
    className: (0, _reactStyles.css)(_alertCss["default"].alertTitle)
  }, readerTitle), children && React.createElement("div", {
    className: (0, _reactStyles.css)(_alertCss["default"].alertDescription)
  }, React.createElement("p", null, children)), action && React.createElement("div", {
    className: (0, _reactStyles.css)(_alertCss["default"].alertAction)
  }, React.cloneElement(action, {
    title: title,
    variantLabel: variantLabel
  })));
};

exports.Alert = Alert;
Alert.propTypes = {
  variant: _propTypes["default"].oneOf(['success', 'danger', 'warning', 'info']).isRequired,
  title: _propTypes["default"].node.isRequired,
  action: _propTypes["default"].node,
  children: _propTypes["default"].node,
  className: _propTypes["default"].string,
  'aria-label': _propTypes["default"].string,
  variantLabel: _propTypes["default"].string
};