import * as React from 'react';
import { Instance as TippyInstance } from 'tippy.js';
import { ReactElement } from 'react';
export declare enum PopoverPosition {
    top = "top",
    bottom = "bottom",
    left = "left",
    right = "right"
}
export interface PopoverProps {
    /** Popover position */
    position?: 'top' | 'bottom' | 'left' | 'right';
    /** If true, tries to keep the popover in view by flipping it if necessary */
    enableFlip?: boolean;
    /** Popover additional class */
    className?: string;
    /** The reference element to which the popover is relatively placed to */
    children: ReactElement<any>;
    /** Accessible label, required when header is not present */
    'aria-label'?: string;
    /** Header content, leave empty for no header */
    headerContent?: React.ReactNode;
    /** Body content */
    bodyContent: React.ReactNode;
    footerContent?: React.ReactNode;
    /**
     * True to show the popover programmatically. Used in conjunction with the shouldClose prop.
     * By default, the popover child element handles click events automatically. If you want to control this programmatically,
     * the popover will not auto-close if the Close button is clicked, ESC key is used, or if a click occurs outside the popover.
     * Instead, the consumer is responsible for closing the popover themselves by adding a callback listener for the shouldClose prop.
     */
    isVisible?: boolean;
    /**
     * Callback function that is only invoked when isVisible is also controlled. Called when the popover Close button is
     * clicked or the ESC key is used
     */
    shouldClose?: (tip: TippyInstance) => void;
    /** The element to append the popover to, defaults to body */
    appendTo?: Element | ((ref: Element) => Element);
    /** Hides the popover when a click occurs outside (only works if isVisible is not controlled by the user) */
    hideOnOutsideClick?: boolean;
    /** Lifecycle function invoked when the popover begins to transition out. */
    onHide?: (tip: TippyInstance) => void;
    /** Lifecycle function invoked when the popover has fully transitioned out. */
    onHidden?: (tip: TippyInstance) => void;
    /** Lifecycle function invoked when the popover begins to transition in. */
    onShow?: (tip: TippyInstance) => void;
    /** Lifecycle function invoked when the popover has fully transitioned in. */
    onShown?: (tip: TippyInstance) => void;
    /** Lifecycle function invoked when the popover has been mounted to the DOM. */
    onMount?: (tip: TippyInstance) => void;
    /** z-index of the popover */
    zIndex?: number;
    /** Maximum width of the tooltip (default 18.75rem) */
    maxWidth?: string;
    /** Aria label for the Close button */
    closeBtnAriaLabel?: string;
}
export interface PopoverState {
    isOpen: boolean;
}
export declare class Popover extends React.Component<PopoverProps, PopoverState> {
    private tip;
    static defaultProps: {
        position: string;
        enableFlip: boolean;
        className: string;
        isVisible: boolean;
        shouldClose: () => void;
        'aria-label': string;
        headerContent: React.FunctionComponent<import("./PopoverHeader").PopoverHeaderProps>;
        footerContent: React.FunctionComponent<import("./PopoverFooter").PopoverFooterProps>;
        appendTo: () => HTMLElement;
        hideOnOutsideClick: boolean;
        onHide: () => void;
        onHidden: () => void;
        onShow: () => void;
        onShown: () => void;
        onMount: () => void;
        zIndex: number;
        maxWidth: "" | "calc(1.5rem + 18.75rem)";
        closeBtnAriaLabel: string;
    };
    constructor(props: PopoverProps);
    hideOrNotify: () => void;
    handleEscKeyClick: (event: KeyboardEvent) => void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    storeTippyInstance: (tip: TippyInstance) => void;
    closePopover: () => void;
    hideAllPopovers: () => void;
    onHide: (tip: TippyInstance) => void;
    onHidden: (tip: TippyInstance) => void;
    onMount: (tip: TippyInstance) => void;
    onShow: (tip: TippyInstance) => void;
    onShown: (tip: TippyInstance) => void;
    render(): JSX.Element | Error;
}
