"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "react-dom", "@patternfly/react-styles", "../../@patternfly/patternfly/components/Backdrop/backdrop.css.js", "exenv", "../../helpers/constants", "./AboutModalContainer"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("react-dom"), require("@patternfly/react-styles"), require("../../@patternfly/patternfly/components/Backdrop/backdrop.css.js"), require("exenv"), require("../../helpers/constants"), require("./AboutModalContainer"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactDom, global.reactStyles, global.backdropCss, global.exenv, global.constants, global.AboutModalContainer);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _reactDom, _reactStyles, _backdropCss, _exenv, _constants, _AboutModalContainer) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.AboutModal = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var ReactDOM = _interopRequireWildcard(_reactDom);

  var _backdropCss2 = _interopRequireDefault(_backdropCss);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _typeof2(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof2 = function _typeof2(obj) {
        return typeof obj;
      };
    } else {
      _typeof2 = function _typeof2(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof2(obj);
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  ;

  var AboutModal = exports.AboutModal = function (_React$Component) {
    _inherits(AboutModal, _React$Component);

    function AboutModal(props) {
      var _this;

      _classCallCheck(this, AboutModal);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(AboutModal).call(this, props));

      _defineProperty(_assertThisInitialized(_this), "id", AboutModal.currentId++);

      _defineProperty(_assertThisInitialized(_this), "ariaLabelledBy", "pf-about-modal-title-".concat(_this.id));

      _defineProperty(_assertThisInitialized(_this), "ariaDescribedBy", "pf-about-modal-content-".concat(_this.id));

      _defineProperty(_assertThisInitialized(_this), "handleEscKeyClick", function (event) {
        if (event.keyCode === _constants.KEY_CODES.ESCAPE_KEY && _this.props.isOpen) {
          _this.props.onClose();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "appendContainer", function () {
        if (!_this.container) {
          _this.container = document.createElement('div');
          document.body.appendChild(_this.container);
          document.addEventListener('keydown', _this.handleEscKeyClick, false);
        }

        if (_this.props.isOpen) {
          document.body.classList.add((0, _reactStyles.css)(_backdropCss2["default"].backdropOpen));
        } else {
          document.body.classList.remove((0, _reactStyles.css)(_backdropCss2["default"].backdropOpen));
        }
      });

      if (props.brandImageSrc && !props.brandImageAlt) {
        // tslint:disable-next-line:no-console
        console.error('AboutModal:', 'brandImageAlt is required when a brandImageSrc is specified');
      }

      return _this;
    }

    _createClass(AboutModal, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.appendContainer();
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        if (this.props.isOpen) {
          document.body.classList.add((0, _reactStyles.css)(_backdropCss2["default"].backdropOpen));
        } else {
          document.body.classList.remove((0, _reactStyles.css)(_backdropCss2["default"].backdropOpen));
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        if (this.container) {
          document.body.removeChild(this.container);
        }

        document.removeEventListener('keydown', this.handleEscKeyClick, false);
      }
    }, {
      key: "render",
      value: function render() {
        if (!_exenv.canUseDOM) {
          return null;
        }

        if (_exenv.canUseDOM && !this.container) {
          this.appendContainer();
        }

        return ReactDOM.createPortal(React.createElement(_AboutModalContainer.AboutModalContainer, _extends({
          ariaLabelledbyId: this.ariaLabelledBy,
          ariaDescribedById: this.ariaDescribedBy
        }, this.props)), this.container);
      }
    }]);

    return AboutModal;
  }(React.Component);

  _defineProperty(AboutModal, "propTypes", {
    children: _propTypes2["default"].node.isRequired,
    className: _propTypes2["default"].string,
    isOpen: _propTypes2["default"].bool,
    onClose: _propTypes2["default"].func,
    productName: _propTypes2["default"].string,
    trademark: _propTypes2["default"].string,
    brandImageSrc: _propTypes2["default"].string.isRequired,
    brandImageAlt: _propTypes2["default"].string.isRequired,
    backgroundImageSrc: _propTypes2["default"].string,
    noAboutModalBoxContentContainer: _propTypes2["default"].bool
  });

  _defineProperty(AboutModal, "currentId", 0);

  _defineProperty(AboutModal, "defaultProps", {
    className: '',
    isOpen: false,
    onClose: function onClose() {
      return undefined;
    },
    productName: '',
    trademark: '',
    backgroundImageSrc: '',
    noAboutModalBoxContentContainer: false
  });
});