/*
  @license
	Rollup.js v2.6.1
	Sun, 12 Apr 2020 21:37:03 GMT - commit e440b709a2861726183d57b4b1f25d049ed1ed6c


	https://github.com/rollup/rollup

	Released under the MIT License.
*/
'use strict';

var rollup_js = require('./rollup.js');

const commandAliases = {
    c: 'config',
    d: 'dir',
    e: 'external',
    f: 'format',
    g: 'globals',
    h: 'help',
    i: 'input',
    m: 'sourcemap',
    n: 'name',
    o: 'file',
    p: 'plugin',
    v: 'version',
    w: 'watch',
};
function mergeOptions(config, rawCommandOptions = { external: [], globals: undefined }, defaultOnWarnHandler) {
    const command = getCommandOptions(rawCommandOptions);
    const inputOptions = rollup_js.parseInputOptions(config, command, defaultOnWarnHandler);
    const warn = inputOptions.onwarn;
    if (command.output) {
        Object.assign(command, command.output);
    }
    const outputOptionsArray = rollup_js.ensureArray(config.output);
    if (outputOptionsArray.length === 0)
        outputOptionsArray.push({});
    const outputOptions = outputOptionsArray.map((singleOutputOptions) => rollup_js.parseOutputOptions(singleOutputOptions, warn, command));
    rollup_js.warnUnknownOptions(command, Object.keys(inputOptions).concat(Object.keys(outputOptions[0]).filter((option) => option !== 'sourcemapPathTransform'), Object.keys(commandAliases), 'config', 'environment', 'plugin', 'silent', 'stdin'), 'CLI flags', warn, /^_$|output$|config/);
    inputOptions.output = outputOptions;
    return inputOptions;
}
function getCommandOptions(rawCommandOptions) {
    const external = rawCommandOptions.external && typeof rawCommandOptions.external === 'string'
        ? rawCommandOptions.external.split(',')
        : [];
    return {
        ...rawCommandOptions,
        external,
        globals: typeof rawCommandOptions.globals === 'string'
            ? rawCommandOptions.globals.split(',').reduce((globals, globalDefinition) => {
                const [id, variableName] = globalDefinition.split(':');
                globals[id] = variableName;
                if (external.indexOf(id) === -1) {
                    external.push(id);
                }
                return globals;
            }, Object.create(null))
            : undefined,
    };
}

exports.commandAliases = commandAliases;
exports.mergeOptions = mergeOptions;
//# sourceMappingURL=mergeOptions.js.map
