package org.keycloak.services.util;

import com.fasterxml.jackson.core.type.TypeReference;
import org.keycloak.util.JsonSerialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;

/**
 * This class is used to parse the Vite manifest file which is generated by the build, this file contains
 * a mapping of non-hashed asset filenames to their hashed versions, which can then be used to render the
 * correct asset links for scripts, styles, etc.
 *
 * @see <a href="https://vitejs.dev/guide/backend-integration.html">Vite documentation — Backend Integration</a>
 */
public class ViteManifest {
    public static final String MANIFEST_FILE_PATH = ".vite/manifest.json";
    public static final String ACCOUNT_VITE_URL = "KC_ACCOUNT_VITE_URL";
    public static final String ADMIN_VITE_URL = "KC_ADMIN_VITE_URL";

    private final HashMap<String, Chunk> manifest;

    private ViteManifest(HashMap<String, Chunk> value) {
        this.manifest = value;
    }

    public static ViteManifest parseFromInputStream(InputStream input) throws IOException {
        final var typeRef = new TypeReference<HashMap<String, Chunk>>() {};
        final var value = JsonSerialization.readValue(input, typeRef);

        return new ViteManifest(value);
    }

    public Chunk getEntryChunk() {
        return manifest.values().stream()
                .filter(chunk -> chunk.isEntry().orElse(false))
                .findFirst()
                .orElseThrow();
    }
}
