"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsMenu = exports.OptionsMenuDirection = exports.OptionsMenuPosition = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _optionsMenuCss = _interopRequireDefault(require("../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js"));

var _reactStyles = require("@patternfly/react-styles");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var OptionsMenuPosition;
exports.OptionsMenuPosition = OptionsMenuPosition;

(function (OptionsMenuPosition) {
  OptionsMenuPosition["right"] = "right";
  OptionsMenuPosition["left"] = "left";
})(OptionsMenuPosition || (exports.OptionsMenuPosition = OptionsMenuPosition = {}));

var OptionsMenuDirection;
exports.OptionsMenuDirection = OptionsMenuDirection;

(function (OptionsMenuDirection) {
  OptionsMenuDirection["up"] = "up";
  OptionsMenuDirection["down"] = "down";
})(OptionsMenuDirection || (exports.OptionsMenuDirection = OptionsMenuDirection = {}));

var OptionsMenu = function OptionsMenu(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      _ref$isPlain = _ref.isPlain,
      isPlain = _ref$isPlain === void 0 ? false : _ref$isPlain,
      _ref$ariaLabelMenu = _ref.ariaLabelMenu,
      ariaLabelMenu = _ref$ariaLabelMenu === void 0 ? '' : _ref$ariaLabelMenu,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? OptionsMenuDirection.down : _ref$direction,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? OptionsMenuPosition.left : _ref$position,
      id = _ref.id,
      menuItems = _ref.menuItems,
      toggle = _ref.toggle,
      props = _objectWithoutProperties(_ref, ["className", "isOpen", "isPlain", "ariaLabelMenu", "direction", "position", "id", "menuItems", "toggle"]);

  return React.createElement("div", _extends({
    id: id,
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenu, direction === OptionsMenuDirection.up && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'top'), position === OptionsMenuPosition.right && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'align-right'), isOpen && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'expanded'), className)
  }, props), React.Children.map(toggle, function (oneToggle) {
    return React.cloneElement(oneToggle, {
      parentId: id,
      isOpen: isOpen,
      isPlain: isPlain
    });
  }), isOpen && React.createElement("ul", _extends({
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenuMenu, position === OptionsMenuPosition.right && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'align-right'))
  }, ariaLabelMenu ? {
    'aria-label': ariaLabelMenu
  } : {
    'aria-labelledby': "".concat(id, "-toggle")
  }), menuItems));
};

exports.OptionsMenu = OptionsMenu;
OptionsMenu.propTypes = {
  className: _propTypes["default"].string,
  id: _propTypes["default"].string.isRequired,
  menuItems: _propTypes["default"].arrayOf(_propTypes["default"].node).isRequired,
  toggle: _propTypes["default"].element.isRequired,
  isPlain: _propTypes["default"].bool,
  isOpen: _propTypes["default"].bool,
  ariaLabelMenu: _propTypes["default"].string,
  position: _propTypes["default"].oneOf(['right', 'left']),
  direction: _propTypes["default"].oneOf(['up', 'down'])
};