"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "./AboutModalBoxContent", "./AboutModalBoxHeader", "./AboutModalBoxHero", "./AboutModalBoxBrand", "./AboutModalBoxCloseButton", "./AboutModalBox", "../Backdrop/Backdrop", "../../layouts/Bullseye/Bullseye"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("./AboutModalBoxContent"), require("./AboutModalBoxHeader"), require("./AboutModalBoxHero"), require("./AboutModalBoxBrand"), require("./AboutModalBoxCloseButton"), require("./AboutModalBox"), require("../Backdrop/Backdrop"), require("../../layouts/Bullseye/Bullseye"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.AboutModalBoxContent, global.AboutModalBoxHeader, global.AboutModalBoxHero, global.AboutModalBoxBrand, global.AboutModalBoxCloseButton, global.AboutModalBox, global.Backdrop, global.Bullseye);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _AboutModalBoxContent, _AboutModalBoxHeader, _AboutModalBoxHero, _AboutModalBoxBrand, _AboutModalBoxCloseButton, _AboutModalBox, _Backdrop, _Bullseye) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.AboutModalContainer = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _Backdrop2 = _interopRequireDefault(_Backdrop);

  var _Bullseye2 = _interopRequireDefault(_Bullseye);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  ;

  var AboutModalContainer = exports.AboutModalContainer = function AboutModalContainer(_ref) {
    var children = _ref.children,
        _ref$className = _ref.className,
        className = _ref$className === void 0 ? '' : _ref$className,
        _ref$isOpen = _ref.isOpen,
        isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
        _ref$onClose = _ref.onClose,
        onClose = _ref$onClose === void 0 ? function () {
      return undefined;
    } : _ref$onClose,
        _ref$productName = _ref.productName,
        productName = _ref$productName === void 0 ? '' : _ref$productName,
        trademark = _ref.trademark,
        brandImageSrc = _ref.brandImageSrc,
        brandImageAlt = _ref.brandImageAlt,
        backgroundImageSrc = _ref.backgroundImageSrc,
        ariaLabelledbyId = _ref.ariaLabelledbyId,
        ariaDescribedById = _ref.ariaDescribedById,
        props = _objectWithoutProperties(_ref, ["children", "className", "isOpen", "onClose", "productName", "trademark", "brandImageSrc", "brandImageAlt", "backgroundImageSrc", "ariaLabelledbyId", "ariaDescribedById"]);

    if (!isOpen) {
      return null;
    }

    return React.createElement(_Backdrop2["default"], null, React.createElement(_Bullseye2["default"], null, React.createElement(_AboutModalBox.AboutModalBox, {
      className: className,
      "aria-labelledby": ariaLabelledbyId,
      "aria-describedby": ariaDescribedById
    }, React.createElement(_AboutModalBoxBrand.AboutModalBoxBrand, {
      src: brandImageSrc,
      alt: brandImageAlt
    }), React.createElement(_AboutModalBoxCloseButton.AboutModalBoxCloseButton, {
      onClose: onClose
    }), productName && React.createElement(_AboutModalBoxHeader.AboutModalBoxHeader, {
      id: ariaLabelledbyId,
      productName: productName
    }), React.createElement(_AboutModalBoxContent.AboutModalBoxContent, _extends({
      trademark: trademark,
      id: ariaDescribedById,
      noAboutModalBoxContentContainer: false
    }, props), children), React.createElement(_AboutModalBoxHero.AboutModalBoxHero, {
      backgroundImageSrc: backgroundImageSrc
    }))));
  };

  AboutModalContainer.propTypes = {
    children: _propTypes2["default"].node.isRequired,
    className: _propTypes2["default"].string,
    isOpen: _propTypes2["default"].bool,
    onClose: _propTypes2["default"].func,
    productName: _propTypes2["default"].string,
    trademark: _propTypes2["default"].string,
    brandImageSrc: _propTypes2["default"].string.isRequired,
    brandImageAlt: _propTypes2["default"].string.isRequired,
    backgroundImageSrc: _propTypes2["default"].string,
    ariaLabelledbyId: _propTypes2["default"].string.isRequired,
    ariaDescribedById: _propTypes2["default"].string.isRequired
  };
});