"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-icons", "../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js", "@patternfly/react-styles"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-icons"), require("../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js"), require("@patternfly/react-styles"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactIcons, global.optionsMenuCss, global.reactStyles);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _reactIcons, _optionsMenuCss, _reactStyles) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.OptionsMenuToggle = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _optionsMenuCss2 = _interopRequireDefault(_optionsMenuCss);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  var OptionsMenuToggle = exports.OptionsMenuToggle = function OptionsMenuToggle(_ref) {
    var _ref$parentId = _ref.parentId,
        parentId = _ref$parentId === void 0 ? '' : _ref$parentId,
        _ref$onToggle = _ref.onToggle,
        onToggle = _ref$onToggle === void 0 ? function () {
      return null;
    } : _ref$onToggle,
        _ref$isOpen = _ref.isOpen,
        isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
        _ref$isPlain = _ref.isPlain,
        isPlain = _ref$isPlain === void 0 ? false : _ref$isPlain,
        _ref$isHovered = _ref.isHovered,
        isHovered = _ref$isHovered === void 0 ? false : _ref$isHovered,
        _ref$isActive = _ref.isActive,
        isActive = _ref$isActive === void 0 ? false : _ref$isActive,
        _ref$isFocused = _ref.isFocused,
        isFocused = _ref$isFocused === void 0 ? false : _ref$isFocused,
        _ref$toggleTemplate = _ref.toggleTemplate,
        toggleTemplate = _ref$toggleTemplate === void 0 ? React.createElement(React.Fragment, null) : _ref$toggleTemplate,
        _ref$hideCaret = _ref.hideCaret,
        hideCaret = _ref$hideCaret === void 0 ? false : _ref$hideCaret,
        _ref$ariaLabel = _ref['aria-label'],
        ariaLabel = _ref$ariaLabel === void 0 ? 'Options menu' : _ref$ariaLabel;
    return React.createElement("button", {
      className: (0, _reactStyles.css)(_optionsMenuCss2["default"].optionsMenuToggle, isPlain && (0, _reactStyles.getModifier)(_optionsMenuCss2["default"], 'plain'), isHovered && (0, _reactStyles.getModifier)(_optionsMenuCss2["default"], 'hover'), isActive && (0, _reactStyles.getModifier)(_optionsMenuCss2["default"], 'active'), isFocused && (0, _reactStyles.getModifier)(_optionsMenuCss2["default"], 'focus')),
      id: "".concat(parentId, "-toggle"),
      "aria-haspopup": "listbox",
      "aria-label": ariaLabel,
      "aria-expanded": isOpen,
      onClick: onToggle
    }, toggleTemplate && (!isPlain ? React.createElement("span", {
      className: (0, _reactStyles.css)(_optionsMenuCss2["default"].optionsMenuToggleText)
    }, toggleTemplate) : React.createElement(React.Fragment, null, toggleTemplate)), !hideCaret && React.createElement(_reactIcons.CaretDownIcon, {
      "aria-hidden": true,
      className: (0, _reactStyles.css)(_optionsMenuCss2["default"].optionsMenuToggleIcon)
    }));
  };

  OptionsMenuToggle.propTypes = {
    parentId: _propTypes2["default"].string,
    onToggle: _propTypes2["default"].func,
    isOpen: _propTypes2["default"].bool,
    isPlain: _propTypes2["default"].bool,
    isFocused: _propTypes2["default"].bool,
    isHovered: _propTypes2["default"].bool,
    isActive: _propTypes2["default"].bool,
    hideCaret: _propTypes2["default"].bool,
    'aria-label': _propTypes2["default"].string,
    toggleTemplate: _propTypes2["default"].element
  };
});