function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { css as emotionCSS, cx, injectGlobal } from 'emotion';
import { formatClassName, getCSSClasses, isModifier, createStyleDeclaration, isValidStyleDeclaration, getClassName } from './utils';
export const StyleSheet = {
  create(styleObj) {
    const keys = Object.keys(styleObj);

    if (keys.length > 0) {
      return keys.reduce((prev, key) => _objectSpread({}, prev, {
        [key]: emotionCSS(styleObj[key])
      }), {});
    }

    return emotionCSS(styleObj);
  },

  parse(input) {
    const classes = getCSSClasses(input);

    if (!classes) {
      return {};
    }

    return classes.reduce((map, className) => {
      const key = formatClassName(className);

      if (map[key]) {
        return map;
      }

      const value = createStyleDeclaration(className, input);

      if (isModifier(className)) {
        map.modifiers[key] = value;
      } else {
        map[key] = value;
      }

      return map;
    }, {
      modifiers: {},
      inject: () => injectGlobal(input),
      raw: input
    });
  }

};
export function css(...styles) {
  const filteredStyles = [];
  styles.forEach(style => {
    if (isValidStyleDeclaration(style)) {
      // remove global injection of styles in favor of require(css) in the component
      // style.__inject();
      filteredStyles.push(getClassName(style));
      return;
    }

    filteredStyles.push(style);
  });
  return cx(...filteredStyles);
}
//# sourceMappingURL=StyleSheet.js.map