"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsMenuItem = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _reactStyles = require("@patternfly/react-styles");

var _optionsMenuCss = _interopRequireDefault(require("../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js"));

var _reactIcons = require("@patternfly/react-icons");

var _helpers = require("../../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var OptionsMenuItem = function OptionsMenuItem(_ref) {
  var _ref$children = _ref.children,
      children = _ref$children === void 0 ? null : _ref$children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$isSelected = _ref.isSelected,
      isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      _ref$onSelect = _ref.onSelect,
      onSelect = _ref$onSelect === void 0 ? function () {
    return null;
  } : _ref$onSelect,
      _ref$id = _ref.id,
      id = _ref$id === void 0 ? '' : _ref$id,
      props = _objectWithoutProperties(_ref, ["children", "className", "isSelected", "isDisabled", "onSelect", "id"]);

  var onKeyDown = function onKeyDown(event) {
    // Detected key press on this item, notify the menu parent so that the appropriate
    // item can be focused
    if (event.keyCode === _helpers.KEY_CODES.TAB) {
      return;
    }

    event.preventDefault();

    if (event.keyCode === _helpers.KEY_CODES.ENTER) {
      onSelect(event);
    }
  };

  return React.createElement("li", null, React.createElement("button", _extends({
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenuMenuItem, isDisabled && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'disabled'), className),
    "aria-disabled": isDisabled,
    onClick: onSelect,
    onKeyDown: onKeyDown,
    "aria-selected": isSelected,
    id: id
  }, props), children, React.createElement("i", {
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenuMenuItemIcon),
    "aria-hidden": true,
    hidden: !isSelected
  }, React.createElement(_reactIcons.CheckIcon, null))));
};

exports.OptionsMenuItem = OptionsMenuItem;
OptionsMenuItem.propTypes = {
  children: _propTypes["default"].node,
  className: _propTypes["default"].string,
  isSelected: _propTypes["default"].bool,
  isDisabled: _propTypes["default"].bool,
  onSelect: _propTypes["default"].func,
  id: _propTypes["default"].string
};