"use strict";
/**
 * @fileoverview Really small utility functions that didn't deserve their own files
 */
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_estree_1 = require("@typescript-eslint/typescript-estree");
/**
 * Check if the context file name is *.ts or *.tsx
 */
function isTypeScriptFile(fileName) {
    return /\.tsx?$/i.test(fileName || '');
}
exports.isTypeScriptFile = isTypeScriptFile;
/**
 * Check if the context file name is *.d.ts or *.d.tsx
 */
function isDefinitionFile(fileName) {
    return /\.d\.tsx?$/i.test(fileName || '');
}
exports.isDefinitionFile = isDefinitionFile;
/**
 * Upper cases the first character or the string
 */
function upperCaseFirst(str) {
    return str[0].toUpperCase() + str.slice(1);
}
exports.upperCaseFirst = upperCaseFirst;
/**
 * Gets a string name representation of the given PropertyName node
 */
function getNameFromPropertyName(propertyName) {
    if (propertyName.type === typescript_estree_1.AST_NODE_TYPES.Identifier) {
        return propertyName.name;
    }
    return `${propertyName.value}`;
}
exports.getNameFromPropertyName = getNameFromPropertyName;
//# sourceMappingURL=misc.js.map