import _pt from "prop-types";

var _cssVariables;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import { css, StyleSheet } from '@patternfly/react-styles';
import styles from "../../@patternfly/patternfly/components/BackgroundImage/background-image.css.js";
/* eslint-disable camelcase */

import { c_background_image_BackgroundImage, c_background_image_BackgroundImage_2x, c_background_image_BackgroundImage_sm, c_background_image_BackgroundImage_sm_2x, c_background_image_BackgroundImage_lg } from '@patternfly/react-tokens';
export var BackgroundImageSrc;

(function (BackgroundImageSrc) {
  BackgroundImageSrc["xs"] = "xs";
  BackgroundImageSrc["xs2x"] = "xs2x";
  BackgroundImageSrc["sm"] = "sm";
  BackgroundImageSrc["sm2x"] = "sm2x";
  BackgroundImageSrc["lg"] = "lg";
  BackgroundImageSrc["filter"] = "filter";
})(BackgroundImageSrc || (BackgroundImageSrc = {}));

;
var cssVariables = (_cssVariables = {}, _defineProperty(_cssVariables, BackgroundImageSrc.xs, c_background_image_BackgroundImage && c_background_image_BackgroundImage.name), _defineProperty(_cssVariables, BackgroundImageSrc.xs2x, c_background_image_BackgroundImage_2x && c_background_image_BackgroundImage_2x.name), _defineProperty(_cssVariables, BackgroundImageSrc.sm, c_background_image_BackgroundImage_sm && c_background_image_BackgroundImage_sm.name), _defineProperty(_cssVariables, BackgroundImageSrc.sm2x, c_background_image_BackgroundImage_sm_2x && c_background_image_BackgroundImage_sm_2x.name), _defineProperty(_cssVariables, BackgroundImageSrc.lg, c_background_image_BackgroundImage_lg && c_background_image_BackgroundImage_lg.name), _cssVariables);
;
;
export var BackgroundImage = function BackgroundImage(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      src = _ref.src,
      props = _objectWithoutProperties(_ref, ["className", "src"]);

  var srcMap = src; // Default string value to handle all sizes

  if (typeof src === 'string') {
    var _srcMap;

    srcMap = (_srcMap = {}, _defineProperty(_srcMap, BackgroundImageSrc.xs, src), _defineProperty(_srcMap, BackgroundImageSrc.xs2x, src), _defineProperty(_srcMap, BackgroundImageSrc.sm, src), _defineProperty(_srcMap, BackgroundImageSrc.sm2x, src), _defineProperty(_srcMap, BackgroundImageSrc.lg, src), _defineProperty(_srcMap, BackgroundImageSrc.filter, ''), _srcMap);
  } // Build stylesheet string based on cssVariables


  var cssSheet = '';
  Object.keys(cssVariables).forEach(function (size) {
    cssSheet += "".concat(cssVariables[size], ": url('").concat(srcMap[size], "');");
  }); // Create emotion stylesheet to inject new css

  var bgStyles = StyleSheet.create({
    bgOverrides: "&.pf-c-background-image {\n      ".concat(cssSheet, "\n    }")
  });
  return React.createElement("div", _extends({
    className: css(styles.backgroundImage, bgStyles.bgOverrides, className)
  }, props), React.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    className: "pf-c-background-image__filter",
    width: "0",
    height: "0"
  }, React.createElement("filter", {
    id: "image_overlay",
    width: "0"
  }, React.createElement("feColorMatrix", {
    type: "matrix",
    values: "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0"
  }), React.createElement("feComponentTransfer", {
    colorInterpolationFilters: "sRGB",
    result: "duotone"
  }, React.createElement("feFuncR", {
    type: "table",
    tableValues: "0.086274509803922 0.43921568627451"
  }), React.createElement("feFuncG", {
    type: "table",
    tableValues: "0.086274509803922 0.43921568627451"
  }), React.createElement("feFuncB", {
    type: "table",
    tableValues: "0.086274509803922 0.43921568627451"
  }), React.createElement("feFuncA", {
    type: "table",
    tableValues: "0 1"
  })))));
};
BackgroundImage.propTypes = {
  className: _pt.string,
  src: _pt.oneOfType([_pt.string, _pt.shape({
    xs: _pt.string.isRequired,
    xs2x: _pt.string.isRequired,
    sm: _pt.string.isRequired,
    sm2x: _pt.string.isRequired,
    lg: _pt.string.isRequired,
    filter: _pt.string
  })]).isRequired
};