import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from "../../@patternfly/patternfly/components/EmptyState/empty-state.css.js";
export var EmptyStateVariant;

(function (EmptyStateVariant) {
  EmptyStateVariant["large"] = "large";
  EmptyStateVariant["small"] = "small";
  EmptyStateVariant["full"] = "full";
})(EmptyStateVariant || (EmptyStateVariant = {}));

;
export var maxWidthModifiers;

(function (maxWidthModifiers) {
  maxWidthModifiers["large"] = "styles.modifiers.lg";
  maxWidthModifiers["small"] = "styles.modifiers.sm";
})(maxWidthModifiers || (maxWidthModifiers = {}));

export var EmptyState = function EmptyState(_ref) {
  var children = _ref.children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? EmptyStateVariant.large : _ref$variant,
      props = _objectWithoutProperties(_ref, ["children", "className", "variant"]);

  var maxWidthModifier = variant && maxWidthModifiers[variant];
  return React.createElement("div", _extends({
    className: css(styles.emptyState, maxWidthModifier, className)
  }, props), children);
};
EmptyState.propTypes = {
  className: _pt.string,
  children: _pt.node.isRequired,
  variant: _pt.oneOf(['small', 'large', 'full'])
};