import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import styles from "../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js";
import { css, getModifier } from '@patternfly/react-styles';
export var OptionsMenuPosition;

(function (OptionsMenuPosition) {
  OptionsMenuPosition["right"] = "right";
  OptionsMenuPosition["left"] = "left";
})(OptionsMenuPosition || (OptionsMenuPosition = {}));

export var OptionsMenuDirection;

(function (OptionsMenuDirection) {
  OptionsMenuDirection["up"] = "up";
  OptionsMenuDirection["down"] = "down";
})(OptionsMenuDirection || (OptionsMenuDirection = {}));

export var OptionsMenu = function OptionsMenu(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      _ref$isPlain = _ref.isPlain,
      isPlain = _ref$isPlain === void 0 ? false : _ref$isPlain,
      _ref$ariaLabelMenu = _ref.ariaLabelMenu,
      ariaLabelMenu = _ref$ariaLabelMenu === void 0 ? '' : _ref$ariaLabelMenu,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? OptionsMenuDirection.down : _ref$direction,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? OptionsMenuPosition.left : _ref$position,
      id = _ref.id,
      menuItems = _ref.menuItems,
      toggle = _ref.toggle,
      props = _objectWithoutProperties(_ref, ["className", "isOpen", "isPlain", "ariaLabelMenu", "direction", "position", "id", "menuItems", "toggle"]);

  return React.createElement("div", _extends({
    id: id,
    className: css(styles.optionsMenu, direction === OptionsMenuDirection.up && getModifier(styles, 'top'), position === OptionsMenuPosition.right && getModifier(styles, 'align-right'), isOpen && getModifier(styles, 'expanded'), className)
  }, props), React.Children.map(toggle, function (oneToggle) {
    return React.cloneElement(oneToggle, {
      parentId: id,
      isOpen: isOpen,
      isPlain: isPlain
    });
  }), isOpen && React.createElement("ul", _extends({
    className: css(styles.optionsMenuMenu, position === OptionsMenuPosition.right && getModifier(styles, 'align-right'))
  }, ariaLabelMenu ? {
    'aria-label': ariaLabelMenu
  } : {
    'aria-labelledby': "".concat(id, "-toggle")
  }), menuItems));
};
OptionsMenu.propTypes = {
  className: _pt.string,
  id: _pt.string.isRequired,
  menuItems: _pt.arrayOf(_pt.node).isRequired,
  toggle: _pt.element.isRequired,
  isPlain: _pt.bool,
  isOpen: _pt.bool,
  ariaLabelMenu: _pt.string,
  position: _pt.oneOf(['right', 'left']),
  direction: _pt.oneOf(['up', 'down'])
};