import _pt from "prop-types";
import * as React from 'react';
import { CaretDownIcon } from '@patternfly/react-icons';
import styles from "../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js";
import { css, getModifier } from '@patternfly/react-styles';
export var OptionsMenuToggle = function OptionsMenuToggle(_ref) {
  var _ref$parentId = _ref.parentId,
      parentId = _ref$parentId === void 0 ? '' : _ref$parentId,
      _ref$onToggle = _ref.onToggle,
      onToggle = _ref$onToggle === void 0 ? function () {
    return null;
  } : _ref$onToggle,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      _ref$isPlain = _ref.isPlain,
      isPlain = _ref$isPlain === void 0 ? false : _ref$isPlain,
      _ref$isHovered = _ref.isHovered,
      isHovered = _ref$isHovered === void 0 ? false : _ref$isHovered,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$isFocused = _ref.isFocused,
      isFocused = _ref$isFocused === void 0 ? false : _ref$isFocused,
      _ref$toggleTemplate = _ref.toggleTemplate,
      toggleTemplate = _ref$toggleTemplate === void 0 ? React.createElement(React.Fragment, null) : _ref$toggleTemplate,
      _ref$hideCaret = _ref.hideCaret,
      hideCaret = _ref$hideCaret === void 0 ? false : _ref$hideCaret,
      _ref$ariaLabel = _ref['aria-label'],
      ariaLabel = _ref$ariaLabel === void 0 ? 'Options menu' : _ref$ariaLabel;
  return React.createElement("button", {
    className: css(styles.optionsMenuToggle, isPlain && getModifier(styles, 'plain'), isHovered && getModifier(styles, 'hover'), isActive && getModifier(styles, 'active'), isFocused && getModifier(styles, 'focus')),
    id: "".concat(parentId, "-toggle"),
    "aria-haspopup": "listbox",
    "aria-label": ariaLabel,
    "aria-expanded": isOpen,
    onClick: onToggle
  }, toggleTemplate && (!isPlain ? React.createElement("span", {
    className: css(styles.optionsMenuToggleText)
  }, toggleTemplate) : React.createElement(React.Fragment, null, toggleTemplate)), !hideCaret && React.createElement(CaretDownIcon, {
    "aria-hidden": true,
    className: css(styles.optionsMenuToggleIcon)
  }));
};
OptionsMenuToggle.propTypes = {
  parentId: _pt.string,
  onToggle: _pt.func,
  isOpen: _pt.bool,
  isPlain: _pt.bool,
  isFocused: _pt.bool,
  isHovered: _pt.bool,
  isActive: _pt.bool,
  hideCaret: _pt.bool,
  'aria-label': _pt.string,
  toggleTemplate: _pt.element
};