/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi.undertow;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.adapters.osgi.PaxWebSecurityConstraintMapping;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PaxWebIntegrationService {
    protected static final Logger log = Logger.getLogger(PaxWebIntegrationService.class);
    private BundleContext bundleContext;
    private List<PaxWebSecurityConstraintMapping> constraintMappings;
    private ServiceTracker webContainerTracker;
    private HttpContext httpContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<PaxWebSecurityConstraintMapping> getConstraintMappings() {
        return this.constraintMappings;
    }

    public void setConstraintMappings(List<PaxWebSecurityConstraintMapping> constraintMappings) {
        this.constraintMappings = constraintMappings;
    }

    protected ServiceTracker getWebContainerTracker() {
        return this.webContainerTracker;
    }

    protected HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void start() {
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                return PaxWebIntegrationService.this.addingWebContainerCallback(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                PaxWebIntegrationService.this.removingWebContainerCallback(reference);
            }
        };
        this.webContainerTracker = new ServiceTracker(this.bundleContext, WebContainer.class.getName(), trackerCustomizer);
        this.webContainerTracker.open();
    }

    public void stop() {
        this.webContainerTracker.remove(this.webContainerTracker.getServiceReference());
    }

    protected WebContainer addingWebContainerCallback(ServiceReference webContainerServiceReference) {
        WebContainer service = (WebContainer)this.bundleContext.getService(webContainerServiceReference);
        this.httpContext = service.createDefaultHttpContext();
        if (this.constraintMappings == null) {
            throw new IllegalStateException("constraintMappings was null!");
        }
        for (PaxWebSecurityConstraintMapping constraintMapping : this.constraintMappings) {
            this.addConstraintMapping(service, constraintMapping);
        }
        service.registerLoginConfig("KEYCLOAK", "specified-in-keycloak-json", null, null, this.httpContext);
        return service;
    }

    protected void addConstraintMapping(WebContainer service, PaxWebSecurityConstraintMapping cm) {
        log.debug((Object)("Adding security constraint name=" + cm.getConstraintName() + ", url=" + cm.getUrl() + ", dataConstraint=" + cm.getDataConstraint() + ", canAuthenticate=" + cm.isAuthentication() + ", roles=" + cm.getRoles()));
        service.registerConstraintMapping(cm.getConstraintName(), cm.getMapping(), cm.getUrl(), cm.getDataConstraint(), cm.isAuthentication(), cm.getRoles(), this.httpContext);
    }

    protected void removingWebContainerCallback(ServiceReference serviceReference) {
        WebContainer service = (WebContainer)this.bundleContext.getService(serviceReference);
        if (service != null) {
            service.unregisterLoginConfig(this.httpContext);
            service.unregisterConstraintMapping(this.httpContext);
        }
    }
}

