/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.enums;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.keycloak.ClientConnection;

public enum SslRequired {
    ALL,
    EXTERNAL,
    NONE;


    public boolean isRequired(ClientConnection connection) {
        return this.isRequired(connection.getRemoteAddr());
    }

    public boolean isRequired(String address) {
        switch (this) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case EXTERNAL: {
                return !this.isLocal(address);
            }
        }
        return true;
    }

    private boolean isLocal(String remoteAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(remoteAddress);
            return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

