/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.smallrye.config.ConfigValue;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.DefaultFactory;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Help;
import org.keycloak.quarkus.runtime.cli.HelpFactory;
import org.keycloak.quarkus.runtime.cli.PropertyMapperParameterConsumer;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.cli.SubCommandListRenderer;
import org.keycloak.quarkus.runtime.cli.command.Main;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.ConfigCategory;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public final class Picocli {
    public static final String ARG_PREFIX = "--";
    private static final String ARG_KEY_VALUE_SEPARATOR = "=";
    public static final String ARG_SHORT_PREFIX = "-";
    public static final String NO_PARAM_LABEL = "none";

    private Picocli() {
    }

    public static void parseAndRun(List<String> cliArgs) {
        CommandLine cmd = Picocli.createCommandLine(cliArgs);
        if (Environment.isRebuildCheck()) {
            int exitCode = Picocli.runReAugmentationIfNeeded(cliArgs, cmd);
            Picocli.exitOnFailure(exitCode, cmd);
            return;
        }
        int exitCode = cmd.execute(cliArgs.toArray(new String[0]));
        Picocli.exitOnFailure(exitCode, cmd);
    }

    private static void exitOnFailure(int exitCode, CommandLine cmd) {
        if (exitCode != cmd.getCommandSpec().exitCodeOnSuccess() && !Environment.isTestLaunchMode()) {
            System.exit(exitCode);
        }
    }

    private static int runReAugmentationIfNeeded(List<String> cliArgs, CommandLine cmd) {
        int exitCode = 0;
        if (Picocli.hasAutoBuildOption(cliArgs) && !Picocli.isHelpCommand(cliArgs)) {
            String profile;
            if (cliArgs.contains("start-dev") && (profile = Environment.getProfile()) == null) {
                Environment.forceDevProfile();
            }
            if (Picocli.requiresReAugmentation(cmd)) {
                exitCode = Picocli.runReAugmentation(cliArgs, cmd);
            }
        }
        return exitCode;
    }

    private static boolean isHelpCommand(List<String> cliArgs) {
        return cliArgs.contains("--help") || cliArgs.contains("-h") || cliArgs.contains("--help-all");
    }

    public static boolean hasAutoBuildOption(List<String> cliArgs) {
        return cliArgs.contains("--auto-build") || cliArgs.contains("-b");
    }

    public static boolean requiresReAugmentation(CommandLine cmd) {
        if (Picocli.hasConfigChanges()) {
            Predicate<String> profileOptionMatcher = "--profile"::equals;
            if (ConfigArgsConfigSource.hasOptionValue(profileOptionMatcher = profileOptionMatcher.or("-pf"::equals), "dev") && !ConfigArgsConfigSource.getAllCliArgs().contains("start-dev")) {
                return false;
            }
            if (!Environment.isDevMode() && cmd != null) {
                cmd.getOut().println("Changes detected in configuration. Updating the server image.");
            }
            return true;
        }
        return Picocli.hasProviderChanges();
    }

    private static List<String> getSanitizedRuntimeCliOptions() {
        final ArrayList<String> properties = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                PropertyMapper mapper = PropertyMappers.getMapper(key);
                if (mapper != null && mapper.isBuildTime()) {
                    return;
                }
                properties.add(key + Picocli.ARG_KEY_VALUE_SEPARATOR + PropertyMappers.formatValue(key, value));
            }
        });
        return properties;
    }

    private static int runReAugmentation(List<String> cliArgs, CommandLine cmd) {
        int exitCode = 0;
        ArrayList<String> configArgsList = new ArrayList<String>(cliArgs);
        configArgsList.remove("--auto-build");
        configArgsList.remove("-b");
        configArgsList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String arg) {
                if (arg.equals("start") || arg.equals("start-dev")) {
                    return "build";
                }
                return arg;
            }
        });
        exitCode = cmd.execute(configArgsList.toArray(new String[0]));
        if (!Environment.isDevMode() && exitCode == cmd.getCommandSpec().exitCodeOnSuccess()) {
            cmd.getOut().printf("Next time you run the server, just run:%n%n\t%s %s %s%n%n", Environment.getCommand(), "start", String.join((CharSequence)" ", Picocli.getSanitizedRuntimeCliOptions()));
        }
        return exitCode;
    }

    private static boolean hasProviderChanges() {
        Map persistedProps = PersistedConfigSource.getInstance().getProperties();
        Map<String, File> deployedProviders = Environment.getProviderFiles();
        if (persistedProps.isEmpty()) {
            return !deployedProviders.isEmpty();
        }
        Set providerKeys = persistedProps.keySet().stream().filter(Picocli::isProviderKey).collect(Collectors.toSet());
        if (deployedProviders.size() != providerKeys.size()) {
            return true;
        }
        for (String key : providerKeys) {
            String fileName = key.substring("kc.provider.file".length() + 1, key.lastIndexOf(46));
            if (!deployedProviders.containsKey(fileName)) {
                return true;
            }
            File file = deployedProviders.get(fileName);
            String lastModified = (String)persistedProps.get(key);
            if (lastModified.equals(String.valueOf(file.lastModified()))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConfigChanges() {
        Optional<String> currentProfile = Optional.ofNullable(Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getBuildTimeProperty("kc.profile");
        if (!persistedProfile.orElse("").equals(currentProfile.orElse(""))) {
            return true;
        }
        for (String propertyName : Configuration.getConfig().getPropertyNames()) {
            ConfigValue configValue;
            if (!PropertyMappers.isBuildTimeProperty(propertyName) || (configValue = Configuration.getConfig().getConfigValue(propertyName)) == null || configValue.getConfigSourceName() == null) continue;
            if (propertyName.startsWith("%")) {
                propertyName = propertyName.substring(propertyName.indexOf(46) + 1);
            }
            String persistedValue = Configuration.getBuildTimeProperty(propertyName).orElse("");
            String runtimeValue = Configuration.getRuntimeProperty(propertyName).orElse(null);
            if (runtimeValue == null && StringUtil.isNotBlank((String)persistedValue)) {
                PropertyMapper mapper = PropertyMappers.getMapper(propertyName);
                if (mapper != null && persistedValue.equals(mapper.getDefaultValue())) continue;
                return true;
            }
            if (persistedValue.equals(runtimeValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isProviderKey(String key) {
        return key.startsWith("kc.provider.file");
    }

    public static CommandLine createCommandLine(List<String> cliArgs) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new Main(), (CommandLine.IFactory)new DefaultFactory()).name(Environment.getCommand());
        for (CommandLine subCommand : spec.subcommands().values()) {
            CommandLine.Model.CommandSpec subCommandSpec = subCommand.getCommandSpec();
            subCommandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])Help.OPTION_NAMES).usageHelp(true).description(new String[]{"This help message."})).build());
        }
        Picocli.addOption(spec, "start", Picocli.hasAutoBuildOption(cliArgs), true);
        Picocli.addOption(spec, "start-dev", true, true);
        Picocli.addOption(spec, "build", true, Picocli.hasAutoBuildOption(cliArgs));
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExecutionExceptionHandler());
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        cmd.setHelpFactory((CommandLine.IHelpFactory)new HelpFactory());
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setErr(new PrintWriter(System.err, true));
        return cmd;
    }

    private static void addOption(CommandLine.Model.CommandSpec spec, String command, boolean includeBuildTime, boolean includeRuntime) {
        CommandLine.Model.CommandSpec commandSpec = ((CommandLine)spec.subcommands().get(command)).getCommandSpec();
        ArrayList<PropertyMapper> mappers = new ArrayList<PropertyMapper>();
        if (includeRuntime) {
            mappers.addAll(PropertyMappers.getRuntimeMappers());
        }
        if (includeBuildTime) {
            mappers.addAll(PropertyMappers.getBuildTimeMappers());
        }
        Picocli.addMappedOptionsToArgGroups(commandSpec, mappers);
    }

    private static void addMappedOptionsToArgGroups(CommandLine.Model.CommandSpec cSpec, List<PropertyMapper> propertyMappers) {
        for (ConfigCategory category : ConfigCategory.values()) {
            List mappersInCategory = propertyMappers.stream().filter(m -> category.equals((Object)m.getCategory())).collect(Collectors.toList());
            if (mappersInCategory.isEmpty()) continue;
            CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(category.getHeading() + ":").order(category.getOrder()).validate(false);
            for (PropertyMapper mapper : mappersInCategory) {
                String name = mapper.getCliFormat();
                String description = mapper.getDescription();
                if (description == null || cSpec.optionsMap().containsKey(name) || name.endsWith(Configuration.OPTION_PART_SEPARATOR)) continue;
                String defaultValue = mapper.getDefaultValue();
                Iterable<String> expectedValues = mapper.getExpectedValues();
                argGroupBuilder.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).defaultValue(defaultValue)).description(new String[]{description})).paramLabel(mapper.getParamLabel())).completionCandidates(expectedValues)).parameterConsumer(PropertyMapperParameterConsumer.INSTANCE)).type(String.class)).hidden(mapper.isHidden())).build());
            }
            cSpec.addArgGroup(argGroupBuilder.build());
        }
    }

    public static void println(CommandLine cmd, String message) {
        cmd.getOut().println(message);
    }

    public static List<String> parseArgs(String[] rawArgs) {
        if (rawArgs.length == 0) {
            return List.of();
        }
        ConfigArgsConfigSource.setCliArgs(rawArgs);
        ArrayList<String> args = new ArrayList<String>(List.of(rawArgs));
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            String next;
            String arg = (String)iterator.next();
            if (!arg.startsWith("--spi") && !arg.startsWith("-D")) continue;
            iterator.remove();
            if (arg.contains(ARG_KEY_VALUE_SEPARATOR) || (next = (String)iterator.next()).startsWith(ARG_PREFIX)) continue;
            iterator.remove();
        }
        return args;
    }
}

