/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class KcEnvConfigSource
extends EnvConfigSource {
    public KcEnvConfigSource() {
        super(KcEnvConfigSource.buildProperties(), 500);
    }

    private static Map<String, String> buildProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String kcPrefix = StringUtil.replaceNonAlphanumericByUnderscores((String)"kc.".toUpperCase());
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(kcPrefix)) continue;
            properties.put(Configuration.getMappedPropertyName(key), entry.getValue());
        }
        return properties;
    }

    public String getName() {
        return "KcEnvVarConfigSource";
    }
}

