/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.FileAccessor$FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.FileEncoder;
import com.datical.liquibase.ext.checks.config.FileEncoder$FileEncoderDTO;
import com.datical.liquibase.ext.checks.config.IFileAccessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.InputStreamList;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class FileAccessor
implements IFileAccessor {
    /*
     * Loose catch block
     */
    @Override
    public FileAccessor$FileAccessorDTO loadFileContents(String object) {
        Object object2;
        Throwable throwable;
        InputStream inputStream;
        Object object3;
        block22: {
            object3 = Scope.getCurrentScope().getResourceAccessor();
            inputStream = null;
            object3 = object3.openStreams(null, (String)object);
            throwable = null;
            if (object3 == null || ((InputStreamList)object3).size() == 0) {
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("No configuration file named '" + (String)object + "' found.");
                throw new FileNotFoundException("Check settings configuration file not found.");
            }
            object = URLDecoder.decode(((InputStreamList)object3).getURIs().get(0).getRawPath(), "UTF-8");
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Check settings configuration file located at '" + (String)object + "'.");
            inputStream = ((InputStreamList)object3).iterator().next();
            String string = StreamUtil.readStreamAsString(inputStream);
            FileAccessor$FileAccessorDTO fileAccessor$FileAccessorDTO = new FileAccessor$FileAccessorDTO();
            new FileAccessor$FileAccessorDTO().versioned = FileEncoder.isVersioned(string);
            object2 = FileEncoder.decode(string);
            fileAccessor$FileAccessorDTO.contents = ((FileEncoder$FileEncoderDTO)object2).contents;
            fileAccessor$FileAccessorDTO.encoded = ((FileEncoder$FileEncoderDTO)object2).encoded;
            if (fileAccessor$FileAccessorDTO.encoded) {
                object2 = (String)object + ".v4.5";
                try {
                    FileUtil.write(string, new File((String)object2));
                    object = "The file '" + (String)object + "' has been updated so it can be used by your current version of Liquibase, and to simplify resolving merge conflicts in Source Control. No action is required from you. Your original file was backed up as '" + (String)object2 + "', and will work with Liquibase 4.5.0 users who specify it using the --checks-settings-file argument.";
                    Scope.getCurrentScope().getLog(FileAccessor.class).warning((String)object);
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                }
                catch (IOException iOException) {
                    String string2 = "Error creating backup file '" + (String)object2 + "' " + iOException.getMessage();
                    Scope.getCurrentScope().getLog(FileAccessor.class).warning(string2);
                    Scope.getCurrentScope().getUI().sendMessage(string2);
                }
            }
            object2 = fileAccessor$FileAccessorDTO;
            if (object3 == null) break block22;
            ((InputStreamList)object3).close();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return object2;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (object3 != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStreamList)object3).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                ((InputStreamList)object3).close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable5;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeFileContents(String object, String string) {
        InputStreamList inputStreamList = Scope.getCurrentScope().getResourceAccessor().openStreams(null, (String)object);
        Throwable throwable = null;
        try {
            if (inputStreamList == null || inputStreamList.size() == 0) {
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("No configuration file named '" + (String)object + "' found.");
                object = this.createNewFile((String)object);
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Creating new file: ".concat(String.valueOf(object)));
            } else {
                object = URLDecoder.decode(inputStreamList.getURIs().get(0).getRawPath(), "UTF-8");
            }
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Check settings configuration file located at '" + (String)object + "'.");
            FileUtil.write("Quality Checks Version: 1.0\nIMPORTANT: DO NOT MODIFY THIS FILE DIRECTLY. UNRECOVERABLE and UNSUPPORTED ERRORS ARE LIKELY IF YOU EDIT THIS FILE DIRECTLY.\nThis file is created and modified by running commands in the Liquibase CLI.\nFor help using quality checks, visit the documentation at https://docs.liquibase.com/quality-checks\n\n-----------------------------------------------------------------------------------------------\n".concat(String.valueOf(string)), new File((String)object), false);
            if (inputStreamList == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (inputStreamList == null) throw throwable3;
                if (throwable != null) {
                    try {
                        inputStreamList.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    inputStreamList.close();
                }
                throw throwable3;
            }
        }
        inputStreamList.close();
        return;
    }

    private String createNewFile(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            throw new CommandExecutionException("Absolute paths are not permitted, please use a relative path.");
        }
        if (!StringUtil.isEmpty(file.getParent())) {
            file.getParentFile().mkdirs();
        }
        try {
            if (file.createNewFile()) {
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).fine("Existing check settings configuration file not found, it is being created at '" + file.getAbsolutePath() + "'.");
            }
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the file '" + string + "'. Make sure the location is accessible and that files can be created there.", iOException);
        }
        return file.getAbsolutePath();
    }
}

