/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import liquibase.LabelExpression;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.repackaged.org.apache.tools.ant.BuildException;
import liquibase.repackaged.org.apache.tools.ant.types.resources.FileResource;
import liquibase.util.StringUtil;

public abstract class AbstractChangeLogBasedTask
extends BaseLiquibaseTask {
    private String changeLogDirectory;
    private String changeLogFile;
    private String contexts;
    private LabelExpression labels;
    private FileResource outputFile;
    private String outputEncoding;

    @Override
    protected void validateParameters() {
        super.validateParameters();
        if (this.changeLogFile == null) {
            throw new BuildException("Change log file is required.");
        }
    }

    protected Writer getOutputFileWriter() throws IOException {
        return new OutputStreamWriter(this.outputFile.getOutputStream(), this.getOutputEncoding());
    }

    @Override
    public String getChangeLogDirectory() {
        return this.changeLogDirectory;
    }

    public void setChangeLogDirectory(String changeLogDirectory) {
        this.changeLogDirectory = changeLogDirectory;
    }

    @Override
    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public LabelExpression getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = new LabelExpression(labels);
    }

    public FileResource getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileResource outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputEncoding() {
        return StringUtil.trimToNull(this.outputEncoding) == null ? this.getDefaultOutputEncoding() : this.outputEncoding.trim();
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

