/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.repackaged.com.opencsv.bean.AbstractFieldMapEntry;
import liquibase.repackaged.com.opencsv.bean.BeanField;
import liquibase.repackaged.com.opencsv.bean.BeanFieldJoin;
import liquibase.repackaged.com.opencsv.bean.util.OpencsvUtils;

public class RegexToBeanField<T>
extends AbstractFieldMapEntry<String, String, T> {
    private final Pattern regex;

    public RegexToBeanField(String pattern, BeanField<T, String> field, Locale errorLocale) {
        super(field, errorLocale);
        this.regex = OpencsvUtils.compilePattern(pattern, 2, BeanFieldJoin.class, this.errorLocale);
    }

    @Override
    public boolean contains(String key) {
        Matcher m2 = this.regex.matcher(key);
        return m2.matches();
    }

    @Override
    public String getInitializer() {
        return this.regex.pattern();
    }
}

