/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnalyticType;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OrderByClause;
import liquibase.repackaged.net.sf.jsqlparser.expression.PartitionByClause;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowElement;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;

public class FilterOverImpl
extends ASTNodeAccessImpl {
    private final OrderByClause orderBy = new OrderByClause();
    private final PartitionByClause partitionBy = new PartitionByClause();
    private AnalyticType analyticType = AnalyticType.FILTER_ONLY;
    private Expression filterExpression = null;
    private WindowElement windowElement = null;

    public AnalyticType getAnalyticType() {
        return this.analyticType;
    }

    public void setAnalyticType(AnalyticType analyticType) {
        this.analyticType = analyticType;
    }

    public FilterOverImpl withAnalyticType(AnalyticType analyticType) {
        this.setAnalyticType(analyticType);
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderBy.getOrderByElements();
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderBy.setOrderByElements(list);
    }

    public FilterOverImpl withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.partitionBy.getPartitionExpressionList();
    }

    public void setPartitionExpressionList(ExpressionList expressionList) {
        this.setPartitionExpressionList(expressionList, false);
    }

    public void setPartitionExpressionList(ExpressionList expressionList, boolean bl2) {
        this.partitionBy.setPartitionExpressionList(expressionList, bl2);
    }

    public boolean isPartitionByBrackets() {
        return this.partitionBy.isBrackets();
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(Expression expression) {
        this.filterExpression = expression;
    }

    public FilterOverImpl withFilterExpression(Expression expression) {
        this.setFilterExpression(expression);
        return this;
    }

    public WindowElement getWindowElement() {
        return this.windowElement;
    }

    public void setWindowElement(WindowElement windowElement) {
        this.windowElement = windowElement;
    }

    public FilterOverImpl withWindowElement(WindowElement windowElement) {
        this.setWindowElement(windowElement);
        return this;
    }

    public StringBuilder append(StringBuilder stringBuilder) {
        if (this.filterExpression != null) {
            stringBuilder.append("FILTER (WHERE ");
            stringBuilder.append(this.filterExpression.toString());
            stringBuilder.append(")");
            if (this.analyticType != AnalyticType.FILTER_ONLY) {
                stringBuilder.append(" ");
            }
        }
        switch (this.analyticType) {
            case FILTER_ONLY: {
                return stringBuilder;
            }
            case WITHIN_GROUP: {
                stringBuilder.append("WITHIN GROUP");
                break;
            }
            default: {
                stringBuilder.append("OVER");
            }
        }
        stringBuilder.append(" (");
        this.partitionBy.toStringPartitionBy(stringBuilder);
        this.orderBy.toStringOrderByElements(stringBuilder);
        if (this.windowElement != null) {
            if (this.orderBy.getOrderByElements() != null) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.windowElement);
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return this.append(stringBuilder).toString();
    }
}

