/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowCallback;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ConditionalLoaAuthenticator
implements ConditionalAuthenticator,
AuthenticationFlowCallback {
    public static final String LEVEL = "loa-condition-level";
    public static final String STORE_IN_USER_SESSION = "loa-store-in-user-session";
    private static final Logger logger = Logger.getLogger(ConditionalLoaAuthenticator.class);

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        int currentLoa = AuthenticatorUtil.getCurrentLevelOfAuthentication(authSession);
        int requestedLoa = AuthenticatorUtil.getRequestedLevelOfAuthentication(authSession);
        Integer configuredLoa = this.getConfiguredLoa(context);
        return currentLoa < 0 && requestedLoa < 0 || (configuredLoa == null || currentLoa < configuredLoa) && currentLoa < requestedLoa;
    }

    public void onParentFlowSuccess(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        Integer newLoa = this.getConfiguredLoa(context);
        if (newLoa == null) {
            return;
        }
        logger.tracef("Updating LoA to '%d' when authenticating session '%s'", (Object)newLoa, (Object)authSession.getParentSession().getId());
        authSession.setAuthNote("level-of-authentication", String.valueOf(newLoa));
        if (this.isStoreInUserSession(context)) {
            authSession.setUserSessionNote("level-of-authentication", String.valueOf(newLoa));
        }
    }

    private Integer getConfiguredLoa(AuthenticationFlowContext context) {
        try {
            return Integer.parseInt((String)context.getAuthenticatorConfig().getConfig().get(LEVEL));
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.errorv("Invalid configuration: {0}", (Object)LEVEL);
            return null;
        }
    }

    private boolean isStoreInUserSession(AuthenticationFlowContext context) {
        try {
            return Boolean.parseBoolean((String)context.getAuthenticatorConfig().getConfig().get(STORE_IN_USER_SESSION));
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.errorv("Invalid configuration: {0}", (Object)STORE_IN_USER_SESSION);
            return false;
        }
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

