/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPContextManager;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;

public class LDAPServerCapabilitiesManager {
    private static final Logger logger = Logger.getLogger(LDAPServerCapabilitiesManager.class);
    public static final String TEST_CONNECTION = "testConnection";
    public static final String TEST_AUTHENTICATION = "testAuthentication";
    public static final String QUERY_SERVER_CAPABILITIES = "queryServerCapabilities";

    public static LDAPConfig buildLDAPConfig(TestLdapConnectionRepresentation config, RealmModel realm) {
        String bindCredential = config.getBindCredential();
        if (config.getComponentId() != null && "**********".equals(bindCredential)) {
            bindCredential = (String)realm.getComponent(config.getComponentId()).getConfig().getFirst((Object)"bindCredential");
        }
        MultivaluedHashMap configMap = new MultivaluedHashMap();
        configMap.putSingle((Object)"authType", (Object)config.getAuthType());
        configMap.putSingle((Object)"bindDn", (Object)config.getBindDn());
        configMap.putSingle((Object)"bindCredential", (Object)bindCredential);
        configMap.add((Object)"connectionUrl", (Object)config.getConnectionUrl());
        configMap.add((Object)"useTruststoreSpi", (Object)config.getUseTruststoreSpi());
        configMap.putSingle((Object)"connectionTimeout", (Object)config.getConnectionTimeout());
        configMap.add((Object)"startTls", (Object)config.getStartTls());
        return new LDAPConfig(configMap);
    }

    public static Set<LDAPCapabilityRepresentation> queryServerCapabilities(TestLdapConnectionRepresentation config, KeycloakSession session, RealmModel realm) {
        if (!QUERY_SERVER_CAPABILITIES.equals(config.getAction())) {
            ServicesLogger.LOGGER.unknownAction(config.getAction());
            return Collections.emptySet();
        }
        LDAPConfig ldapConfig = LDAPServerCapabilitiesManager.buildLDAPConfig(config, realm);
        return new LDAPIdentityStore(session, ldapConfig).queryServerCapabilities();
    }

    public static boolean testLDAP(TestLdapConnectionRepresentation config, KeycloakSession session, RealmModel realm) {
        boolean bl;
        block12: {
            if (!TEST_CONNECTION.equals(config.getAction()) && !TEST_AUTHENTICATION.equals(config.getAction())) {
                ServicesLogger.LOGGER.unknownAction(config.getAction());
                return false;
            }
            if (TEST_AUTHENTICATION.equals(config.getAction())) {
                if (config.getBindDn() == null || config.getBindDn().isEmpty()) {
                    logger.error((Object)"Unknown bind DN");
                    return false;
                }
            } else {
                config.setAuthType("none");
            }
            LDAPConfig ldapConfig = LDAPServerCapabilitiesManager.buildLDAPConfig(config, realm);
            LDAPContextManager ldapContextManager = LDAPContextManager.create((KeycloakSession)session, (LDAPConfig)ldapConfig);
            try {
                ldapContextManager.getLdapContext();
                bl = true;
                if (ldapContextManager == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (ldapContextManager != null) {
                        try {
                            ldapContextManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ne) {
                    String errorMessage = TEST_AUTHENTICATION.equals(config.getAction()) ? "Error when authenticating to LDAP: " : "Error when connecting to LDAP: ";
                    ServicesLogger.LOGGER.errorAuthenticating(ne, errorMessage + ne.getMessage());
                    return false;
                }
            }
            ldapContextManager.close();
        }
        return bl;
    }
}

