/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.jboss.logging.Logger;

public class DateTimeFormatterUtil {
    private static final Logger log = Logger.getLogger(DateTimeFormatterUtil.class);

    public static String getDateTimeFromMillis(long millis) {
        return DateTimeFormatterUtil.getDateTimeFromMillis(millis, Locale.ENGLISH);
    }

    public static String getDateTimeFromMillis(long millis, String locale) {
        return DateTimeFormatterUtil.getDateTimeFromMillis(millis, DateTimeFormatterUtil.getLocaleFromString(locale));
    }

    public static String getDateTimeFromMillis(long millis, Locale locale) {
        return DateTimeFormatterUtil.getDateTimeFromMillis(millis, DateTimeFormatterUtil.getDefaultDateFormat(locale));
    }

    public static String getDateTimeFromMillis(long millis, DateFormat dateFormat) {
        if (dateFormat == null) {
            return null;
        }
        return dateFormat.format(new Date(millis));
    }

    public static Locale getLocaleFromString(String locale) {
        return DateTimeFormatterUtil.getLocaleFromString(locale, Locale.ENGLISH);
    }

    public static Locale getLocaleFromString(String locale, Locale defaultValue) {
        try {
            return Optional.ofNullable(locale).map(Locale::new).orElse(defaultValue);
        }
        catch (Exception e) {
            log.debugf("Invalid locale '%s'", (Object)locale);
            return defaultValue;
        }
    }

    public static DateFormat getDefaultDateFormat() {
        return DateTimeFormatterUtil.getDefaultDateFormat(Locale.ENGLISH);
    }

    public static DateFormat getDefaultDateFormat(Locale locale) {
        return DateFormat.getDateTimeInstance(2, 3, locale);
    }
}

