/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public final class Version
implements Comparable<Version> {
    private static final Version VERSION = Version.getArtifactVersion();
    private final int major;
    private final int minor;
    private final int micro;
    private final String suffix;
    private final String versionString;

    private static Version getArtifactVersion() {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String suffix = null;
        InputStream res = Version.class.getResourceAsStream("/META-INF/maven/org.infinispan.protostream/protostream/pom.properties");
        if (res != null) {
            try {
                Properties pomProps = new Properties();
                pomProps.load(res);
                String version = pomProps.getProperty("version", "0.0.0-UNKNOWN");
                String[] versionParts = version.split("[.\\-]");
                major = Integer.parseInt(versionParts[0]);
                if (versionParts.length > 1) {
                    minor = Integer.parseInt(versionParts[1]);
                }
                if (versionParts.length > 2) {
                    micro = Integer.parseInt(versionParts[2]);
                }
                if (versionParts.length > 3) {
                    suffix = versionParts[3];
                }
            }
            catch (IOException | ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return new Version(major, minor, micro, suffix);
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static void main(String[] args) {
        System.out.println("ProtoStream version " + Version.getVersion());
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String suffix) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.suffix = suffix;
        this.versionString = major + "." + minor + "." + micro + (suffix != null ? "." + suffix : "");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return other.major == this.major && other.minor == this.minor && other.micro == this.micro && Objects.equals(this.suffix, other.suffix);
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.major + this.minor) + this.micro) + (this.suffix != null ? this.suffix.hashCode() : 0);
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int d = this.major - other.major;
        if (d == 0 && (d = this.minor - other.minor) == 0 && (d = this.micro - other.micro) == 0) {
            d = this.suffix.compareTo(other.suffix);
        }
        return d;
    }
}

