/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.jaxrs.AbstractRestResponseBuilder;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

public class RestResponseBuilderImpl<T>
extends AbstractRestResponseBuilder<T> {
    public RestResponse.ResponseBuilder<T> location(URI location) {
        ResteasyReactiveRequestContext request;
        if (location == null) {
            this.metadata.remove((Object)"Location");
            return this;
        }
        if (!location.isAbsolute() && (request = CurrentRequestManager.get()) != null) {
            ServerHttpRequest req = request.serverRequest();
            try {
                String host = req.getRequestHost();
                int port = -1;
                int index = host.indexOf(":");
                if (index > -1) {
                    port = Integer.parseInt(host.substring(index + 1));
                    host = host.substring(0, index);
                }
                String prefix = "";
                Deployment deployment = request.getDeployment();
                if (deployment != null) {
                    prefix = deployment.getPrefix();
                }
                location = new URI(req.getRequestScheme(), null, host, port, prefix + (String)(location.getPath().startsWith("/") ? location.getPath() : "/" + location.getPath()), location.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.metadata.putSingle((Object)"Location", (Object)location);
        return this;
    }

    public RestResponse.ResponseBuilder<T> contentLocation(URI location) {
        ResteasyReactiveRequestContext request;
        if (location == null) {
            this.metadata.remove((Object)"Content-Location");
            return this;
        }
        if (!location.isAbsolute() && (request = CurrentRequestManager.get()) != null) {
            ServerHttpRequest req = request.serverRequest();
            try {
                String host = req.getRequestHost();
                int port = -1;
                int index = host.indexOf(":");
                if (index > -1) {
                    port = Integer.parseInt(host.substring(index + 1));
                    host = host.substring(0, index);
                }
                location = new URI(req.getRequestScheme(), null, host, port, (String)(location.getPath().startsWith("/") ? location.getPath() : "/" + location.getPath()), location.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.metadata.putSingle((Object)"Content-Location", (Object)location);
        return this;
    }

    protected AbstractRestResponseBuilder<T> doClone() {
        return new RestResponseBuilderImpl<T>();
    }
}

