/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.infinispan.client.deployment.InfinispanClientDevServiceBuildTimeConfig;
import io.quarkus.infinispan.client.deployment.devservices.InfinispanDevServicesConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.server.test.core.InfinispanContainer;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;

public class InfinispanDevServiceProcessor {
    private static final Logger log = Logger.getLogger(InfinispanDevServiceProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-infinispan";
    public static final int DEFAULT_INFINISPAN_PORT = 11222;
    private static final ContainerLocator infinispanContainerLocator = new ContainerLocator("quarkus-dev-service-infinispan", 11222);
    private static final String DEFAULT_PASSWORD = "password";
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";
    private static volatile List<Closeable> closeables;
    private static volatile InfinispanClientDevServiceBuildTimeConfig.DevServiceConfiguration capturedDevServicesConfiguration;
    private static volatile boolean first;
    private static volatile Boolean dockerRunning;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void startInfinispanContainers(LaunchModeBuildItem launchMode, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, BuildProducer<DevServicesConfigResultBuildItem> devConfigProducer, InfinispanClientDevServiceBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        if (closeables != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !config.devService.equals(capturedDevServicesConfiguration);
            if (!restartRequired) {
                return;
            }
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop infinispan container", e);
                }
            }
            closeables = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = config.devService;
        ArrayList<Closeable> currentCloseables = new ArrayList<Closeable>();
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Infinispan Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            StartResult startResult = this.startContainer(config.devService.devservices, launchMode.getLaunchMode(), !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (startResult == null) {
                compressor.close();
                return;
            }
            currentCloseables.add(startResult.closeable);
            devConfigProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(this.getConfigPrefix() + "server-list", startResult.serverList));
            devConfigProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(this.getConfigPrefix() + "client-intelligence", "BASIC"));
            devConfigProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(this.getConfigPrefix() + "auth-username", startResult.user));
            devConfigProducer.produce((BuildItem)new DevServicesConfigResultBuildItem(this.getConfigPrefix() + "auth-password", startResult.password));
            log.infof("The infinispan server is ready to accept connections on %s", (Object)startResult.serverList);
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        closeables = currentCloseables;
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                dockerRunning = null;
                if (closeables != null) {
                    for (Closeable closeable : closeables) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop infinispan", t);
                        }
                    }
                }
                first = true;
                closeables = null;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
    }

    private StartResult startContainer(InfinispanDevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)"Not starting devservices for Infinispan as it has been disabled in the config");
            return null;
        }
        String configPrefix = this.getConfigPrefix();
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)(configPrefix + "server-list"));
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for Infinispan as 'server-list' have been provided");
            return null;
        }
        if (dockerRunning == null) {
            dockerRunning = new IsDockerWorking.IsDockerRunningSilent().getAsBoolean();
        }
        if (!dockerRunning.booleanValue()) {
            log.warn((Object)"Please configure 'quarkus.infinispan-client.server-list' or get a working docker instance");
            return null;
        }
        Supplier<StartResult> defaultInfinispanServerSupplier = () -> {
            QuarkusInfinispanContainer infinispanContainer = new QuarkusInfinispanContainer(devServicesConfig.port, launchMode == LaunchMode.DEVELOPMENT ? devServicesConfig.serviceName : null, useSharedNetwork, devServicesConfig.artifacts);
            timeout.ifPresent(arg_0 -> ((QuarkusInfinispanContainer)infinispanContainer).withStartupTimeout(arg_0));
            infinispanContainer.start();
            String serverList = infinispanContainer.getHost() + ":" + infinispanContainer.getPort();
            String user = infinispanContainer.getUser();
            String secret = infinispanContainer.getPassword();
            return new StartResult(serverList, user, secret, () -> infinispanContainer.close());
        };
        return infinispanContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> new StartResult(containerAddress.getUrl(), "admin", DEFAULT_PASSWORD, null)).orElseGet(defaultInfinispanServerSupplier);
    }

    private String getConfigPrefix() {
        return "quarkus.infinispan-client.";
    }

    static {
        first = true;
        dockerRunning = null;
    }

    private static class QuarkusInfinispanContainer
    extends InfinispanContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusInfinispanContainer(OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork, Optional<List<String>> artifacts) {
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(InfinispanDevServiceProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.withUser("admin");
            this.withPassword(InfinispanDevServiceProcessor.DEFAULT_PASSWORD);
            artifacts.ifPresent(a -> this.withArtifacts(a.toArray(new String[0])));
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"infinispan");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 11222);
            } else {
                this.addExposedPort(11222);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 11222;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getUser() {
            return "admin";
        }

        public String getPassword() {
            return InfinispanDevServiceProcessor.DEFAULT_PASSWORD;
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }

    private static class StartResult {
        private final String serverList;
        private final String user;
        private final String password;
        private final Closeable closeable;

        public StartResult(String sl, String user, String password, Closeable closeable) {
            this.serverList = sl;
            this.user = user;
            this.password = password;
            this.closeable = closeable;
        }
    }
}

