/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;

public class UserManager {
    private KeycloakSession session;

    public UserManager(KeycloakSession session) {
        this.session = session;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.removeUser(realm, user, this.session.users());
    }

    public boolean removeUser(final RealmModel realm, final UserModel user, UserProvider userProvider) {
        if (userProvider.removeUser(realm, user)) {
            this.session.getKeycloakSessionFactory().publish(new UserModel.UserRemovedEvent(){

                @Override
                public RealmModel getRealm() {
                    return realm;
                }

                @Override
                public UserModel getUser() {
                    return user;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return UserManager.this.session;
                }
            });
            return true;
        }
        return false;
    }
}

