/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collection;
import java.util.Map;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.SearchableModelField;

public interface UserSessionModel {
    public static final String CORRESPONDING_SESSION_ID = "correspondingSessionId";

    public String getId();

    public RealmModel getRealm();

    public String getBrokerSessionId();

    public String getBrokerUserId();

    public UserModel getUser();

    public String getLoginUsername();

    public String getIpAddress();

    public String getAuthMethod();

    public boolean isRememberMe();

    public int getStarted();

    public int getLastSessionRefresh();

    public void setLastSessionRefresh(int var1);

    public boolean isOffline();

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions();

    default public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        return this.getAuthenticatedClientSessions().get(clientUUID);
    }

    public void removeAuthenticatedClientSessions(Collection<String> var1);

    public String getNote(String var1);

    public void setNote(String var1, String var2);

    public void removeNote(String var1);

    public Map<String, String> getNotes();

    public State getState();

    public void setState(State var1);

    public void restartSession(RealmModel var1, UserModel var2, String var3, String var4, String var5, boolean var6, String var7, String var8);

    public static enum SessionPersistenceState {
        PERSISTENT,
        TRANSIENT;


        public static SessionPersistenceState fromString(String sessionPersistenceString) {
            return sessionPersistenceString == null ? PERSISTENT : Enum.valueOf(SessionPersistenceState.class, sessionPersistenceString);
        }
    }

    public static enum State {
        LOGGED_IN,
        LOGGING_OUT,
        LOGGED_OUT,
        LOGGED_OUT_UNCONFIRMED;

    }

    public static class SearchableFields {
        public static final SearchableModelField<UserSessionModel> ID = new SearchableModelField("id", String.class);
        public static final SearchableModelField<UserSessionModel> CORRESPONDING_SESSION_ID = new SearchableModelField("correspondingSessionId", String.class);
        public static final SearchableModelField<UserSessionModel> REALM_ID = new SearchableModelField("realmId", String.class);
        public static final SearchableModelField<UserSessionModel> USER_ID = new SearchableModelField("userId", String.class);
        public static final SearchableModelField<UserSessionModel> CLIENT_ID = new SearchableModelField("clientId", String.class);
        public static final SearchableModelField<UserSessionModel> BROKER_SESSION_ID = new SearchableModelField("brokerSessionId", String.class);
        public static final SearchableModelField<UserSessionModel> BROKER_USER_ID = new SearchableModelField("brokerUserId", String.class);
        public static final SearchableModelField<UserSessionModel> IS_OFFLINE = new SearchableModelField("isOffline", Boolean.class);
        public static final SearchableModelField<UserSessionModel> LAST_SESSION_REFRESH = new SearchableModelField("lastSessionRefresh", Integer.class);
    }
}

