/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ServerRunMode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class InfinispanServerTestConfiguration {
    public static final String LON = "LON";
    public static final String NYC = "NYC";
    private static final Map<String, Integer> SITE_DISCOVER_PORTS_OFFSET;
    private static final int DEFAULT_DISCOVER_PORT = 46655;
    private final String configurationFile;
    private final int numServers;
    private final ServerRunMode runMode;
    private final Properties properties;
    private final String[] mavenArtifacts;
    private final JavaArchive[] archives;
    private final boolean jmx;
    private final boolean parallelStartup;
    private final List<InfinispanServerListener> listeners;
    private boolean defaultFile;
    private final String site;
    private final int portOffset;
    private final String[] features;

    public InfinispanServerTestConfiguration(String configurationFile, int numServers, ServerRunMode runMode, Properties properties, String[] mavenArtifacts, JavaArchive[] archives, boolean jmx, boolean parallelStartup, boolean defaultFile, List<InfinispanServerListener> listeners, String site, int portOffset, String[] features) {
        this.configurationFile = configurationFile;
        this.numServers = numServers;
        this.runMode = runMode;
        this.properties = properties;
        this.mavenArtifacts = mavenArtifacts;
        this.archives = archives;
        this.jmx = jmx;
        this.parallelStartup = parallelStartup;
        this.defaultFile = defaultFile;
        this.listeners = Collections.unmodifiableList(listeners);
        this.site = site;
        this.portOffset = portOffset;
        this.features = features;
    }

    public String configurationFile() {
        return this.configurationFile;
    }

    public int numServers() {
        return this.numServers;
    }

    public ServerRunMode runMode() {
        return this.runMode;
    }

    public Properties properties() {
        return this.properties;
    }

    public JavaArchive[] archives() {
        return this.archives;
    }

    public boolean isJMXEnabled() {
        return this.jmx;
    }

    public String[] mavenArtifacts() {
        return this.mavenArtifacts;
    }

    public boolean isParallelStartup() {
        return this.parallelStartup;
    }

    public boolean isDefaultFile() {
        return this.defaultFile;
    }

    public List<InfinispanServerListener> listeners() {
        return this.listeners;
    }

    public String site() {
        return this.site;
    }

    public int siteDiscoveryPort() {
        return 46655 + this.sitePortOffset();
    }

    public int sitePortOffset() {
        return SITE_DISCOVER_PORTS_OFFSET.get(this.site);
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public String[] getFeatures() {
        return this.features;
    }

    static {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put(LON, 1000);
        ports.put(NYC, 2000);
        SITE_DISCOVER_PORTS_OFFSET = Collections.unmodifiableMap(ports);
    }
}

