/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultWorkspaceModule
implements WorkspaceModule,
Serializable {
    public static final String MAIN = "";
    public static final String TEST = "tests";
    private final WorkspaceModuleId id;
    private final File moduleDir;
    private final File buildDir;
    private PathCollection buildFiles;
    private final Map<String, ArtifactSources> sourcesSets = new HashMap<String, ArtifactSources>();
    private List<Dependency> directDepConstraints = Collections.emptyList();
    private List<Dependency> directDeps = Collections.emptyList();

    public DefaultWorkspaceModule(WorkspaceModuleId id, File moduleDir, File buildDir) {
        this.id = id;
        this.moduleDir = moduleDir;
        this.buildDir = buildDir;
    }

    @Override
    public WorkspaceModuleId getId() {
        return this.id;
    }

    @Override
    public File getModuleDir() {
        return this.moduleDir;
    }

    @Override
    public File getBuildDir() {
        return this.buildDir;
    }

    public void addArtifactSources(ArtifactSources src) {
        this.sourcesSets.put(src.getClassifier(), src);
    }

    @Override
    public boolean hasSources(String classifier) {
        return this.sourcesSets.containsKey(classifier);
    }

    @Override
    public ArtifactSources getSources(String name) {
        return this.sourcesSets.get(name);
    }

    @Override
    public Collection<String> getSourceClassifiers() {
        return this.sourcesSets.keySet();
    }

    public void setBuildFiles(PathCollection buildFiles) {
        this.buildFiles = buildFiles;
    }

    @Override
    public PathCollection getBuildFiles() {
        return this.buildFiles == null ? PathList.empty() : this.buildFiles;
    }

    @Override
    public Collection<Dependency> getDirectDependencyConstraints() {
        return this.directDepConstraints;
    }

    public void setDirectDependencyConstraints(List<Dependency> directDepConstraints) {
        this.directDepConstraints = directDepConstraints;
    }

    @Override
    public Collection<Dependency> getDirectDependencies() {
        return this.directDeps;
    }

    public void setDirectDependencies(List<Dependency> directDeps) {
        this.directDeps = directDeps;
    }

    public void addDirectDependency(Dependency directDep) {
        if (this.directDeps.isEmpty()) {
            this.directDeps = new ArrayList<Dependency>();
        }
        this.directDeps.add(directDep);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" ").append(this.moduleDir);
        this.sourcesSets.values().forEach(a -> buf.append(" ").append(a));
        return buf.toString();
    }
}

