/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.PathCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class PathList
implements PathCollection,
Serializable {
    private List<Path> paths;

    public static PathList from(Iterable<Path> paths) {
        ArrayList<Path> list = new ArrayList<Path>();
        paths.forEach(list::add);
        return new PathList(list);
    }

    public static PathList of(Path ... paths) {
        return new PathList(Arrays.asList(paths));
    }

    public static PathList empty() {
        return new PathList(Collections.emptyList());
    }

    public static Builder builder() {
        return new Builder();
    }

    private PathList(List<Path> paths) {
        this.paths = Collections.unmodifiableList(paths);
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    @Override
    public boolean isSinglePath() {
        return this.paths.size() == 1;
    }

    @Override
    public Path getSinglePath() {
        if (this.paths.size() != 1) {
            throw new IllegalStateException("Paths collection expected to contain a single path but contains " + this.paths.size());
        }
        return this.paths.get(0);
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    @Override
    public boolean contains(Path path) {
        return this.paths.contains(path);
    }

    @Override
    public PathList add(Path ... paths) {
        ArrayList<Path> list = new ArrayList<Path>(this.paths.size() + paths.length);
        list.addAll(this.paths);
        for (int i = 0; i < paths.length; ++i) {
            list.add(paths[i]);
        }
        return new PathList(list);
    }

    @Override
    public PathList addFirst(Path ... paths) {
        ArrayList<Path> list = new ArrayList<Path>(this.paths.size() + paths.length);
        for (int i = 0; i < paths.length; ++i) {
            list.add(paths[i]);
        }
        list.addAll(this.paths);
        return new PathList(list);
    }

    @Override
    public PathList addAllFirst(Iterable<Path> i) {
        ArrayList<Path> list = new ArrayList<Path>();
        i.forEach(list::add);
        this.paths.forEach(list::add);
        return new PathList(list);
    }

    @Override
    public Path resolveExistingOrNull(String path) {
        for (Path p : this.paths) {
            Path resolved = p.resolve(path);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[paths: ");
        this.forEach(p -> buf.append(p).append(';'));
        return buf.append(']').toString();
    }

    public int hashCode() {
        return Objects.hash(this.paths);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathList other = (PathList)obj;
        return Objects.equals(this.paths, other.paths);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.paths.size());
        for (Path p : this.paths) {
            out.writeUTF(p.toAbsolutePath().toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int pathsTotal = in.readInt();
        ArrayList<Path> paths = new ArrayList<Path>(pathsTotal);
        for (int i = 0; i < pathsTotal; ++i) {
            paths.add(Paths.get(in.readUTF(), new String[0]));
        }
        this.paths = Collections.unmodifiableList(paths);
    }

    public static class Builder {
        private List<Path> paths = new ArrayList<Path>();

        private Builder() {
        }

        public Builder add(Path path) {
            this.paths.add(path);
            return this;
        }

        public boolean contains(Path p) {
            return this.paths.contains(p);
        }

        public boolean isEmpty() {
            return this.paths.isEmpty();
        }

        public PathList build() {
            return new PathList(this.paths);
        }
    }
}

