/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.infinispan.TaskCallback;
import org.keycloak.cluster.infinispan.WrapperClusterEvent;
import org.keycloak.common.util.ConcurrentMultivaluedHashMap;
import org.keycloak.common.util.Retry;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProviderFactory;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.models.KeycloakSession;

public class InfinispanNotificationsManager {
    protected static final Logger logger = Logger.getLogger(InfinispanNotificationsManager.class);
    private final ConcurrentMultivaluedHashMap<String, ClusterListener> listeners = new ConcurrentMultivaluedHashMap();
    private final ConcurrentMap<String, TaskCallback> taskCallbacks = new ConcurrentHashMap<String, TaskCallback>();
    private final Cache<String, Serializable> workCache;
    private final RemoteCache workRemoteCache;
    private final String myAddress;
    private final String mySite;
    private final ExecutorService listenersExecutor;

    protected InfinispanNotificationsManager(Cache<String, Serializable> workCache, RemoteCache workRemoteCache, String myAddress, String mySite, ExecutorService listenersExecutor) {
        this.workCache = workCache;
        this.workRemoteCache = workRemoteCache;
        this.myAddress = myAddress;
        this.mySite = mySite;
        this.listenersExecutor = listenersExecutor;
    }

    public static InfinispanNotificationsManager create(KeycloakSession session, Cache<String, Serializable> workCache, String myAddress, String mySite, Set<RemoteStore> remoteStores) {
        RemoteCache workRemoteCache = null;
        if (!remoteStores.isEmpty()) {
            RemoteStore remoteStore = remoteStores.iterator().next();
            workRemoteCache = remoteStore.getRemoteCache();
            if (mySite == null) {
                throw new IllegalStateException("Multiple datacenters available, but site name is not configured! Check your configuration");
            }
        }
        ExecutorService listenersExecutor = workRemoteCache == null ? null : ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("work-cache-event-listener");
        InfinispanNotificationsManager manager = new InfinispanNotificationsManager(workCache, workRemoteCache, myAddress, mySite, listenersExecutor);
        workCache.addListener((Object)manager.new CacheEntryListener());
        logger.debugf("Added listener for infinispan cache: %s", (Object)workCache.getName());
        if (workRemoteCache != null) {
            InfinispanNotificationsManager infinispanNotificationsManager = manager;
            Objects.requireNonNull(infinispanNotificationsManager);
            workRemoteCache.addClientListener((Object)infinispanNotificationsManager.new HotRodListener((RemoteCache<Object, Object>)workRemoteCache));
            logger.debugf("Added listener for HotRod remoteStore cache: %s", (Object)workRemoteCache.getName());
        }
        return manager;
    }

    void registerListener(String taskKey, ClusterListener task) {
        this.listeners.add((Object)taskKey, (Object)task);
    }

    TaskCallback registerTaskCallback(String taskKey, TaskCallback callback) {
        TaskCallback existing = this.taskCallbacks.putIfAbsent(taskKey, callback);
        if (existing != null) {
            return existing;
        }
        return callback;
    }

    void notify(String taskKey, ClusterEvent event, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        WrapperClusterEvent wrappedEvent = new WrapperClusterEvent();
        wrappedEvent.setEventKey(taskKey);
        wrappedEvent.setDelegateEvent(event);
        wrappedEvent.setIgnoreSender(ignoreSender);
        wrappedEvent.setIgnoreSenderSite(dcNotify == ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
        wrappedEvent.setSender(this.myAddress);
        wrappedEvent.setSenderSite(this.mySite);
        String eventKey = UUID.randomUUID().toString();
        if (logger.isTraceEnabled()) {
            logger.tracef("Sending event with key %s: %s", (Object)eventKey, (Object)event);
        }
        if (dcNotify == ClusterProvider.DCNotify.LOCAL_DC_ONLY || this.workRemoteCache == null) {
            this.workCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_CACHE_STORE}).put((Object)eventKey, (Object)wrappedEvent, 120L, TimeUnit.SECONDS);
        } else {
            Retry.executeWithBackoff(iteration -> {
                try {
                    Class<DefaultInfinispanConnectionProviderFactory> clazz = DefaultInfinispanConnectionProviderFactory.class;
                    synchronized (DefaultInfinispanConnectionProviderFactory.class) {
                        this.workRemoteCache.put((Object)eventKey, (Object)wrappedEvent, 120L, TimeUnit.SECONDS);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                    }
                }
                catch (HotRodClientException re) {
                    if (logger.isDebugEnabled()) {
                        logger.debugf((Throwable)re, "Failed sending notification to remote cache '%s'. Key: '%s', iteration '%s'. Will try to retry the task", (Object)this.workRemoteCache.getName(), (Object)eventKey, (Object)iteration);
                    }
                    throw re;
                }
                {
                    return;
                }
            }, (int)10, (int)10);
        }
    }

    private void eventReceived(String key, Serializable obj) {
        if (!(obj instanceof WrapperClusterEvent)) {
            if (obj == null) {
                logger.warnf("Event object wasn't available in remote cache after event was received. Event key: %s", (Object)key);
            }
            return;
        }
        WrapperClusterEvent event = (WrapperClusterEvent)((Object)obj);
        if (event.isIgnoreSender() && this.myAddress.equals(event.getSender())) {
            return;
        }
        if (event.isIgnoreSenderSite() && (this.mySite == null || this.mySite.equals(event.getSenderSite()))) {
            return;
        }
        String eventKey = event.getEventKey();
        if (logger.isTraceEnabled()) {
            logger.tracef("Received event: %s", (Object)event);
        }
        ClusterEvent wrappedEvent = event.getDelegateEvent();
        List myListeners = (List)this.listeners.get((Object)eventKey);
        if (myListeners != null) {
            for (ClusterListener listener : myListeners) {
                listener.eventReceived(wrappedEvent);
            }
        }
    }

    void taskFinished(String taskKey, boolean success) {
        TaskCallback callback = (TaskCallback)this.taskCallbacks.remove(taskKey);
        if (callback != null) {
            if (logger.isDebugEnabled()) {
                logger.debugf("Finished task '%s' with '%b'", (Object)taskKey, (Object)success);
            }
            callback.setSuccess(success);
            callback.getTaskCompletedLatch().countDown();
        }
    }

    @ClientListener
    public class HotRodListener {
        private final RemoteCache<Object, Object> remoteCache;

        public HotRodListener(RemoteCache<Object, Object> remoteCache) {
            this.remoteCache = remoteCache;
        }

        @ClientCacheEntryCreated
        public void created(ClientCacheEntryCreatedEvent event) {
            String key = event.getKey().toString();
            this.hotrodEventReceived(key);
        }

        @ClientCacheEntryModified
        public void updated(ClientCacheEntryModifiedEvent event) {
            String key = event.getKey().toString();
            this.hotrodEventReceived(key);
        }

        @ClientCacheEntryRemoved
        public void removed(ClientCacheEntryRemovedEvent event) {
            String key = event.getKey().toString();
            InfinispanNotificationsManager.this.taskFinished(key, true);
        }

        private void hotrodEventReceived(String key) {
            try {
                InfinispanNotificationsManager.this.listenersExecutor.submit(() -> {
                    Class<DefaultInfinispanConnectionProviderFactory> clazz = DefaultInfinispanConnectionProviderFactory.class;
                    synchronized (DefaultInfinispanConnectionProviderFactory.class) {
                        Object value = this.remoteCache.get((Object)key);
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        InfinispanNotificationsManager.this.eventReceived(key, (Serializable)value);
                        return;
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                logger.errorf("Rejected submitting of the event for key: %s. Value: %s, Server going to shutdown or pool exhausted. Pool: %s", (Object)key, InfinispanNotificationsManager.this.workCache.get((Object)key), (Object)InfinispanNotificationsManager.this.listenersExecutor.toString());
                throw ree;
            }
        }
    }

    @Listener(observation=Listener.Observation.POST)
    public class CacheEntryListener {
        @CacheEntryCreated
        public void cacheEntryCreated(CacheEntryCreatedEvent<String, Serializable> event) {
            InfinispanNotificationsManager.this.eventReceived((String)event.getKey(), (Serializable)event.getValue());
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<String, Serializable> event) {
            InfinispanNotificationsManager.this.eventReceived((String)event.getKey(), (Serializable)event.getValue());
        }

        @CacheEntryRemoved
        public void cacheEntryRemoved(CacheEntryRemovedEvent<String, Serializable> event) {
            InfinispanNotificationsManager.this.taskFinished((String)event.getKey(), true);
        }
    }
}

