/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.ws.rs.ApplicationPath;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.services.resources.QuarkusWelcomeResource;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.WelcomeResource;

@ApplicationPath(value="/")
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    private static final String KEYCLOAK_ADMIN_ENV_VAR = "KEYCLOAK_ADMIN";
    private static final String KEYCLOAK_ADMIN_PASSWORD_ENV_VAR = "KEYCLOAK_ADMIN_PASSWORD";
    @Inject
    Instance<EntityManagerFactory> entityManagerFactory;

    private static boolean filterSingletons(Object o) {
        return !WelcomeResource.class.isInstance(o);
    }

    protected void startup() {
        this.forceEntityManagerInitialization();
        this.initializeKeycloakSessionFactory();
        QuarkusKeycloakApplication.setupScheduledTasks((KeycloakSessionFactory)sessionFactory);
        this.createAdminUser();
    }

    public Set<Object> getSingletons() {
        Set<Object> singletons = super.getSingletons().stream().filter(QuarkusKeycloakApplication::filterSingletons).collect(Collectors.toSet());
        singletons.add(new QuarkusWelcomeResource());
        return singletons;
    }

    private void initializeKeycloakSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        sessionFactory = instance;
        instance.init();
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent());
    }

    private void forceEntityManagerInitialization() {
        ((EntityManagerFactory)this.entityManagerFactory.get()).createEntityManager().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAdminUser() {
        String adminUserName = System.getenv(KEYCLOAK_ADMIN_ENV_VAR);
        String adminPassword = System.getenv(KEYCLOAK_ADMIN_PASSWORD_ENV_VAR);
        if (adminUserName == null || adminUserName.trim().length() == 0 || adminPassword == null || adminPassword.trim().length() == 0) {
            return;
        }
        KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
        KeycloakSession session = sessionFactory.create();
        KeycloakTransactionManager transaction = session.getTransactionManager();
        try {
            transaction.begin();
            new ApplianceBootstrap(session).createMasterRealmUser(adminUserName, adminPassword);
            ServicesLogger.LOGGER.addUserSuccess(adminUserName, Config.getAdminRealm());
            transaction.commit();
        }
        catch (IllegalStateException e) {
            session.getTransactionManager().rollback();
            ServicesLogger.LOGGER.addUserFailedUserExists(adminUserName, Config.getAdminRealm());
        }
        catch (Throwable t) {
            session.getTransactionManager().rollback();
            ServicesLogger.LOGGER.addUserFailed(t, adminUserName, Config.getAdminRealm());
        }
        finally {
            session.close();
        }
    }
}

