/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.liquibase;

import java.lang.reflect.Method;
import java.sql.Connection;
import javax.xml.parsers.SAXParserFactory;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class QuarkusLiquibaseConnectionProvider
implements LiquibaseConnectionProviderFactory,
LiquibaseConnectionProvider {
    private static final Logger logger = Logger.getLogger(QuarkusLiquibaseConnectionProvider.class);
    private volatile boolean initialized = false;
    private ClassLoaderResourceAccessor resourceAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiquibaseConnectionProvider create(KeycloakSession session) {
        if (!this.initialized) {
            QuarkusLiquibaseConnectionProvider quarkusLiquibaseConnectionProvider = this;
            synchronized (quarkusLiquibaseConnectionProvider) {
                if (!this.initialized) {
                    this.baseLiquibaseInitialization(session);
                    this.initialized = true;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void baseLiquibaseInitialization(KeycloakSession session) {
        this.resourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
        for (ChangeLogParser parser : ChangeLogParserFactory.getInstance().getParsers()) {
            if (!(parser instanceof XMLChangeLogSAXParser)) continue;
            Method getSaxParserFactory = null;
            try {
                getSaxParserFactory = XMLChangeLogSAXParser.class.getDeclaredMethod("getSaxParserFactory", new Class[0]);
                getSaxParserFactory.setAccessible(true);
                SAXParserFactory saxParserFactory = (SAXParserFactory)getSaxParserFactory.invoke((Object)parser, new Object[0]);
                saxParserFactory.setValidating(false);
                saxParserFactory.setSchema(null);
            }
            catch (Exception e) {
                logger.warnf("Failed to disable liquibase XML validations", new Object[0]);
            }
            finally {
                if (getSaxParserFactory == null) continue;
                getSaxParserFactory.setAccessible(false);
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "quarkus";
    }

    public Liquibase getLiquibase(Connection connection, String defaultSchema) throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        String changelog = "META-INF/jpa-changelog-master.xml";
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelog, (Object)database.getDatabaseChangeLogTableName());
        return new Liquibase(changelog, (ResourceAccessor)this.resourceAccessor, database);
    }

    public Liquibase getLiquibaseForCustomUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(classloader);
        database.setDatabaseChangeLogTableName(changelogTableName);
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelogLocation, (Object)database.getDatabaseChangeLogTableName());
        return new Liquibase(changelogLocation, (ResourceAccessor)resourceAccessor, database);
    }

    public int order() {
        return 100;
    }
}

