/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class CookieAuthenticator
implements Authenticator {
    public boolean requiresUser() {
        return false;
    }

    public void authenticate(AuthenticationFlowContext context) {
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(context.getSession(), context.getRealm(), true);
        if (authResult == null) {
            context.attempted();
        } else {
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, authSession.getProtocol());
            authSession.setAuthNote("level-of-authentication", authResult.getSession().getNote("level-of-authentication"));
            context.setUser(authResult.getUser());
            if (protocol.requireReauthentication(authResult.getSession(), authSession)) {
                authSession.setAuthNote("level-of-authentication", String.valueOf(-1));
                context.setForwardedInfoMessage("reauthenticate", new Object[0]);
                context.attempted();
            } else if (!AuthenticatorUtil.isLevelOfAuthenticationSatisfied(authSession)) {
                context.attempted();
            } else {
                authSession.setAuthNote("level-of-authentication", String.valueOf(-1));
                authSession.setAuthNote("SSO_AUTH", "true");
                context.attachUserSession(authResult.getSession());
                context.success();
            }
        }
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

