/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;

public class UserCredentialStoreManager
extends AbstractStorageManager<UserStorageProvider, UserStorageProviderModel>
implements UserCredentialManager.Streams,
OnUserCache {
    public UserCredentialStoreManager(KeycloakSession session) {
        super(session, UserStorageProviderFactory.class, UserStorageProvider.class, UserStorageProviderModel::new, "user");
    }

    protected UserCredentialStore getStoreForUser(UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return (UserCredentialStore)this.session.userLocalStorage();
        }
        return (UserCredentialStore)this.session.userFederatedStorage();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.throwExceptionIfInvalidUser(user);
        this.getStoreForUser(user).updateCredential(realm, user, cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.throwExceptionIfInvalidUser(user);
        return this.getStoreForUser(user).createCredential(realm, user, cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        this.throwExceptionIfInvalidUser(user);
        boolean removalResult = this.getStoreForUser(user).removeStoredCredential(realm, user, id);
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        return removalResult;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).getStoredCredentialById(realm, user, id);
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        return this.getStoreForUser(user).getStoredCredentialsStream(realm, user);
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        return this.getStoreForUser(user).getStoredCredentialsByTypeStream(realm, user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoreForUser(user).getStoredCredentialByNameAndType(realm, user, name, type);
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        this.throwExceptionIfInvalidUser(user);
        return this.getStoreForUser(user).moveCredentialTo(realm, user, id, newPreviousCredentialId);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput ... inputs) {
        return this.isValid(realm, user, Arrays.asList(inputs));
    }

    public CredentialModel createCredentialThroughProvider(RealmModel realm, UserModel user, CredentialModel model) {
        this.throwExceptionIfInvalidUser(user);
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).map(f -> (CredentialProvider)this.session.getProvider(CredentialProvider.class, f.getId())).filter(provider -> Objects.equals(provider.getType(), model.getType())).map(cp -> cp.createCredential(realm, user, cp.getCredentialFromModel(model))).findFirst().orElse(null);
    }

    public void updateCredentialLabel(RealmModel realm, UserModel user, String credentialId, String userLabel) {
        this.throwExceptionIfInvalidUser(user);
        CredentialModel credential = this.getStoredCredentialById(realm, user, credentialId);
        credential.setUserLabel(userLabel);
        this.getStoreForUser(user).updateCredential(realm, user, credential);
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
    }

    public boolean isValid(RealmModel realm, UserModel user, List<CredentialInput> inputs) {
        String providerId;
        if (!this.isValid(user)) {
            return false;
        }
        LinkedList<CredentialInput> toValidate = new LinkedList<CredentialInput>(inputs);
        String string = providerId = StorageId.isLocalStorage((UserModel)user) ? user.getFederationLink() : StorageId.resolveProviderId((UserModel)user);
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, providerId);
            if (model == null || !model.isEnabled()) {
                return false;
            }
            CredentialInputValidator validator2 = this.getStorageProviderInstance(model, CredentialInputValidator.class);
            if (validator2 != null) {
                this.validate(realm, user, toValidate, validator2);
            }
        }
        if (toValidate.isEmpty()) {
            return true;
        }
        UserCredentialStoreManager.getCredentialProviders(this.session, CredentialInputValidator.class).forEach(validator -> this.validate(realm, user, (List<CredentialInput>)toValidate, (CredentialInputValidator)validator));
        return toValidate.isEmpty();
    }

    private void validate(RealmModel realm, UserModel user, List<CredentialInput> toValidate, CredentialInputValidator validator) {
        toValidate.removeIf(input -> validator.supportsCredentialType(input.getType()) && validator.isValid(realm, user, input));
    }

    public static <T> Stream<T> getCredentialProviders(KeycloakSession session, Class<T> type) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports((Class)type, (Object)f, CredentialProviderFactory.class)).map(f -> session.getProvider(CredentialProvider.class, f.getId()));
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        String providerId;
        String string = providerId = StorageId.isLocalStorage((UserModel)user) ? user.getFederationLink() : StorageId.resolveProviderId((UserModel)user);
        if (!StorageId.isLocalStorage((UserModel)user)) {
            this.throwExceptionIfInvalidUser(user);
        }
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, providerId);
            if (model == null || !model.isEnabled()) {
                return false;
            }
            CredentialInputUpdater updater2 = this.getStorageProviderInstance(model, CredentialInputUpdater.class);
            if (updater2 != null && updater2.supportsCredentialType(input.getType()) && updater2.updateCredential(realm, user, input)) {
                return true;
            }
        }
        return UserCredentialStoreManager.getCredentialProviders(this.session, CredentialInputUpdater.class).filter(updater -> updater.supportsCredentialType(input.getType())).anyMatch(updater -> updater.updateCredential(realm, user, input));
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        String providerId;
        String string = providerId = StorageId.isLocalStorage((UserModel)user) ? user.getFederationLink() : StorageId.resolveProviderId((UserModel)user);
        if (!StorageId.isLocalStorage((UserModel)user)) {
            this.throwExceptionIfInvalidUser(user);
        }
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, providerId);
            if (model == null || !model.isEnabled()) {
                return;
            }
            CredentialInputUpdater updater2 = this.getStorageProviderInstance(model, CredentialInputUpdater.class);
            if (updater2.supportsCredentialType(credentialType)) {
                updater2.disableCredentialType(realm, user, credentialType);
            }
        }
        UserCredentialStoreManager.getCredentialProviders(this.session, CredentialInputUpdater.class).filter(updater -> updater.supportsCredentialType(credentialType)).forEach(updater -> updater.disableCredentialType(realm, user, credentialType));
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        String providerId;
        Stream types = Stream.empty();
        String string = providerId = StorageId.isLocalStorage((UserModel)user) ? user.getFederationLink() : StorageId.resolveProviderId((UserModel)user);
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, providerId);
            if (model == null || !model.isEnabled()) {
                return types;
            }
            CredentialInputUpdater updater2 = this.getStorageProviderInstance(model, CredentialInputUpdater.class);
            if (updater2 != null) {
                types = updater2.getDisableableCredentialTypesStream(realm, user);
            }
        }
        return Stream.concat(types, UserCredentialStoreManager.getCredentialProviders(this.session, CredentialInputUpdater.class).flatMap(updater -> updater.getDisableableCredentialTypesStream(realm, user))).distinct();
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String type) {
        UserStorageCredentialConfigured userStorageConfigured = this.isConfiguredThroughUserStorage(realm, user, type);
        switch (userStorageConfigured) {
            case CONFIGURED: {
                return true;
            }
            case USER_STORAGE_DISABLED: {
                return false;
            }
        }
        return this.isConfiguredLocally(realm, user, type);
    }

    private UserStorageCredentialConfigured isConfiguredThroughUserStorage(RealmModel realm, UserModel user, String type) {
        String providerId;
        String string = providerId = StorageId.isLocalStorage((UserModel)user) ? user.getFederationLink() : StorageId.resolveProviderId((UserModel)user);
        if (providerId != null) {
            UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, providerId);
            if (model == null || !model.isEnabled()) {
                return UserStorageCredentialConfigured.USER_STORAGE_DISABLED;
            }
            CredentialInputValidator validator = this.getStorageProviderInstance(model, CredentialInputValidator.class);
            if (validator != null && validator.supportsCredentialType(type) && validator.isConfiguredFor(realm, user, type)) {
                return UserStorageCredentialConfigured.CONFIGURED;
            }
        }
        return UserStorageCredentialConfigured.NOT_CONFIGURED;
    }

    public boolean isConfiguredLocally(RealmModel realm, UserModel user, String type) {
        return UserCredentialStoreManager.getCredentialProviders(this.session, CredentialInputValidator.class).anyMatch(validator -> validator.supportsCredentialType(type) && validator.isConfiguredFor(realm, user, type));
    }

    public CredentialValidationOutput authenticate(KeycloakSession session, RealmModel realm, CredentialInput input) {
        Stream<CredentialAuthentication> credentialAuthenticationStream = this.getEnabledStorageProviders(realm, CredentialAuthentication.class);
        credentialAuthenticationStream = Stream.concat(credentialAuthenticationStream, UserCredentialStoreManager.getCredentialProviders(session, CredentialAuthentication.class));
        return credentialAuthenticationStream.filter(credentialAuthentication -> credentialAuthentication.supportsCredentialAuthenticationFor(input.getType())).map(credentialAuthentication -> credentialAuthentication.authenticate(realm, input)).findFirst().orElse(null);
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        UserCredentialStoreManager.getCredentialProviders(this.session, OnUserCache.class).forEach(validator -> validator.onCache(realm, user, delegate));
    }

    public Stream<String> getConfiguredUserStorageCredentialTypesStream(RealmModel realm, UserModel user) {
        return UserCredentialStoreManager.getCredentialProviders(this.session, CredentialProvider.class).map(CredentialProvider::getType).filter(credentialType -> UserStorageCredentialConfigured.CONFIGURED == this.isConfiguredThroughUserStorage(realm, user, (String)credentialType));
    }

    public void close() {
    }

    private boolean isValid(UserModel user) {
        return user != null && user.getServiceAccountClientLink() == null;
    }

    private void throwExceptionIfInvalidUser(UserModel user) {
        if (user == null || this.isValid(user)) {
            return;
        }
        throw new RuntimeException("You can not manage credentials for this user");
    }

    private static enum UserStorageCredentialConfigured {
        CONFIGURED,
        USER_STORAGE_DISABLED,
        NOT_CONFIGURED;

    }
}

