/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrderedModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.Urls;
import org.keycloak.theme.Theme;

public class IdentityProviderBean {
    public static OrderedModel.OrderedModelComparator<IdentityProvider> IDP_COMPARATOR_INSTANCE = new OrderedModel.OrderedModelComparator();
    private boolean displaySocial;
    private List<IdentityProvider> providers;
    private RealmModel realm;
    private final KeycloakSession session;

    public IdentityProviderBean(RealmModel realm, KeycloakSession session, List<IdentityProviderModel> identityProviders, URI baseURI) {
        this.realm = realm;
        this.session = session;
        if (!identityProviders.isEmpty()) {
            ArrayList<IdentityProvider> orderedList = new ArrayList<IdentityProvider>();
            for (IdentityProviderModel identityProvider : identityProviders) {
                if (!identityProvider.isEnabled() || identityProvider.isLinkOnly()) continue;
                this.addIdentityProvider(orderedList, realm, baseURI, identityProvider);
            }
            if (!orderedList.isEmpty()) {
                orderedList.sort((Comparator<IdentityProvider>)IDP_COMPARATOR_INSTANCE);
                this.providers = orderedList;
                this.displaySocial = true;
            }
        }
    }

    private void addIdentityProvider(List<IdentityProvider> orderedSet, RealmModel realm, URI baseURI, IdentityProviderModel identityProvider) {
        boolean hideOnLoginPage;
        String loginUrl = Urls.identityProviderAuthnRequest(baseURI, identityProvider.getAlias(), realm.getName()).toString();
        String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)identityProvider);
        Map config = identityProvider.getConfig();
        boolean bl = hideOnLoginPage = config != null && Boolean.parseBoolean((String)config.get("hideOnLoginPage"));
        if (!hideOnLoginPage) {
            orderedSet.add(new IdentityProvider(identityProvider.getAlias(), displayName, identityProvider.getProviderId(), loginUrl, config != null ? (String)config.get("guiOrder") : null, this.getLoginIconClasses(identityProvider.getAlias())));
        }
    }

    private String getLoginIconClasses(String alias) {
        String ICON_THEME_PREFIX = "kcLogoIdP-";
        try {
            Theme theme = this.session.theme().getTheme(Theme.Type.LOGIN);
            return Optional.ofNullable(theme.getProperties().getProperty("kcLogoIdP-" + alias)).orElse("");
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public List<IdentityProvider> getProviders() {
        return this.providers;
    }

    public boolean isDisplayInfo() {
        return this.realm.isRegistrationAllowed() || this.displaySocial;
    }

    public static class IdentityProvider
    implements OrderedModel {
        private final String alias;
        private final String providerId;
        private final String loginUrl;
        private final String guiOrder;
        private final String displayName;
        private final String iconClasses;

        public IdentityProvider(String alias, String displayName, String providerId, String loginUrl, String guiOrder) {
            this(alias, displayName, providerId, loginUrl, guiOrder, "");
        }

        public IdentityProvider(String alias, String displayName, String providerId, String loginUrl, String guiOrder, String iconClasses) {
            this.alias = alias;
            this.displayName = displayName;
            this.providerId = providerId;
            this.loginUrl = loginUrl;
            this.guiOrder = guiOrder;
            this.iconClasses = iconClasses;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getLoginUrl() {
            return this.loginUrl;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getGuiOrder() {
            return this.guiOrder;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getIconClasses() {
            return this.iconClasses;
        }
    }
}

