/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.Config;
import org.keycloak.OAuthErrorException;
import org.keycloak.TokenVerifier;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.BackchannelLogoutResponse;
import org.keycloak.protocol.oidc.LogoutTokenValidationCode;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.LogoutToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.LogoutRequestContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.Cors;

public class LogoutEndpoint {
    private static final Logger logger = Logger.getLogger(LogoutEndpoint.class);
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    private TokenManager tokenManager;
    private RealmModel realm;
    private EventBuilder event;
    private boolean offlineSessionsLazyLoadingEnabled;
    private Cors cors;

    public LogoutEndpoint(TokenManager tokenManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.realm = realm;
        this.event = event;
        this.offlineSessionsLazyLoadingEnabled = Config.scope((String[])new String[]{"userSessions"}).scope(new String[]{"infinispan"}).getBoolean("preloadOfflineSessionsFromDatabase", Boolean.valueOf(false)) == false;
    }

    @Path(value="/")
    @OPTIONS
    public Response issueUserInfoPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @NoCache
    public Response logout(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="id_token_hint") String encodedIdToken, @QueryParam(value="post_logout_redirect_uri") String postLogoutRedirectUri, @QueryParam(value="state") String state, @QueryParam(value="initiating_idp") String initiatingIdp) {
        AuthenticationManager.AuthResult authResult;
        String redirect = postLogoutRedirectUri != null ? postLogoutRedirectUri : redirectUri;
        IDToken idToken = null;
        if (encodedIdToken != null) {
            try {
                idToken = this.tokenManager.verifyIDTokenSignature(this.session, encodedIdToken);
                TokenVerifier.createWithoutSignature((JsonWebToken)idToken).tokenType("ID").verify();
            }
            catch (OAuthErrorException | VerificationException e) {
                this.event.event(EventType.LOGOUT);
                this.event.error("invalid_token");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "sessionNotActiveMessage", new Object[0]);
            }
        }
        if (redirect != null) {
            ClientModel client = idToken == null || idToken.getIssuedFor() == null ? null : this.realm.getClientByClientId(idToken.getIssuedFor());
            String validatedUri = client != null ? RedirectUtils.verifyRedirectUri(this.session, redirect, client) : RedirectUtils.verifyRealmRedirectUri(this.session, redirect);
            if (validatedUri == null) {
                this.event.event(EventType.LOGOUT);
                this.event.detail("redirect_uri", redirect);
                this.event.error("invalid_redirect_uri");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidRedirectUriMessage", new Object[0]);
            }
            redirect = validatedUri;
        }
        UserSessionModel userSession = null;
        if (idToken != null) {
            try {
                userSession = this.session.sessions().getUserSession(this.realm, idToken.getSessionState());
                if (userSession != null) {
                    this.checkTokenIssuedAt(idToken, userSession);
                }
            }
            catch (OAuthErrorException e) {
                this.event.event(EventType.LOGOUT);
                this.event.error("invalid_token");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "sessionNotActiveMessage", new Object[0]);
            }
        }
        if ((authResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realm, false)) != null) {
            userSession = userSession != null ? userSession : authResult.getSession();
            return this.initiateBrowserLogout(userSession, redirect, state, initiatingIdp);
        }
        if (userSession != null) {
            if (idToken != null && idToken.getSessionState().equals(AuthenticationManager.getSessionIdFromSessionCookie(this.session))) {
                return this.initiateBrowserLogout(userSession, redirect, state, initiatingIdp);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT && userSession.getState() != UserSessionModel.State.LOGGED_OUT) {
                this.event.event(EventType.LOGOUT);
                AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true);
                this.event.user(userSession.getUser()).session(userSession).success();
            }
        }
        if (redirect != null) {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)redirect);
            if (state != null) {
                uriBuilder.queryParam("state", new Object[]{state});
            }
            return Response.status((int)302).location(uriBuilder.build(new Object[0])).build();
        }
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logoutToken() {
        this.cors = Cors.add(this.request).auth().allowedMethods("POST").auth().exposedHeaders("Access-Control-Allow-Methods");
        MultivaluedMap form = this.request.getDecodedFormParameters();
        this.checkSsl();
        this.event.event(EventType.LOGOUT);
        ClientModel client = this.authorizeClient();
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new LogoutRequestContext((MultivaluedMap<String, String>)form));
        }
        catch (ClientPolicyException cpe) {
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        RefreshToken token = null;
        try {
            UserSessionModel userSessionModel;
            token = this.tokenManager.verifyRefreshToken(this.session, this.realm, client, this.request, refreshToken, false);
            boolean offline = "Offline".equals(token.getType());
            if (offline) {
                UserSessionManager sessionManager = new UserSessionManager(this.session);
                userSessionModel = sessionManager.findOfflineUserSession(this.realm, token.getSessionState());
            } else {
                userSessionModel = this.session.sessions().getUserSession(this.realm, token.getSessionState());
            }
            if (userSessionModel != null) {
                this.checkTokenIssuedAt((IDToken)token, userSessionModel);
                this.logout(userSessionModel, offline);
            }
        }
        catch (OAuthErrorException e) {
            if ("Client certificate missing, or its thumbprint and one in the refresh token did NOT match".equals(e.getDescription())) {
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.UNAUTHORIZED);
            }
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        return this.cors.builder(Response.noContent()).build();
    }

    @Path(value="/backchannel-logout")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response backchannelLogout() {
        MultivaluedMap form = this.request.getDecodedFormParameters();
        this.event.event(EventType.LOGOUT);
        String encodedLogoutToken = (String)form.getFirst((Object)"logout_token");
        if (encodedLogoutToken == null) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", "No logout token", Response.Status.BAD_REQUEST);
        }
        LogoutTokenValidationCode validationCode = this.tokenManager.verifyLogoutToken(this.session, this.realm, encodedLogoutToken);
        if (!validationCode.equals((Object)LogoutTokenValidationCode.VALIDATION_SUCCESS)) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", validationCode.getErrorMessage(), Response.Status.BAD_REQUEST);
        }
        LogoutToken logoutToken = this.tokenManager.toLogoutToken(encodedLogoutToken).get();
        Stream<String> identityProviderAliases = this.tokenManager.getValidOIDCIdentityProvidersForBackchannelLogout(this.realm, this.session, encodedLogoutToken, logoutToken).map(idp -> ((OIDCIdentityProviderConfig)idp.getConfig()).getAlias());
        boolean logoutOfflineSessions = Boolean.parseBoolean(((Object)logoutToken.getEvents().getOrDefault("revoke_offline_access", false)).toString());
        BackchannelLogoutResponse backchannelLogoutResponse = logoutToken.getSid() != null ? this.backchannelLogoutWithSessionId(logoutToken.getSid(), identityProviderAliases, logoutOfflineSessions, logoutToken.getSubject()) : this.backchannelLogoutFederatedUserId(logoutToken.getSubject(), identityProviderAliases, logoutOfflineSessions);
        if (!backchannelLogoutResponse.getLocalLogoutSucceeded()) {
            this.event.error("logout_failed");
            throw new ErrorResponseException("server_error", "There was an error in the local logout", Response.Status.NOT_IMPLEMENTED);
        }
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
        if (this.oneOrMoreDownstreamLogoutsFailed(backchannelLogoutResponse)) {
            return Cors.add(this.request).auth().builder(Response.status((Response.Status)Response.Status.GATEWAY_TIMEOUT).type(MediaType.APPLICATION_JSON_TYPE)).build();
        }
        return Cors.add(this.request).auth().builder(Response.ok().type(MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private BackchannelLogoutResponse backchannelLogoutWithSessionId(String sessionId, Stream<String> identityProviderAliases, boolean logoutOfflineSessions, String federatedUserId) {
        AtomicReference<BackchannelLogoutResponse> backchannelLogoutResponse = new AtomicReference<BackchannelLogoutResponse>(new BackchannelLogoutResponse());
        backchannelLogoutResponse.get().setLocalLogoutSucceeded(true);
        identityProviderAliases.forEach(identityProviderAlias -> {
            UserSessionModel userSession = this.session.sessions().getUserSessionByBrokerSessionId(this.realm, identityProviderAlias + "." + sessionId);
            if (logoutOfflineSessions) {
                if (this.offlineSessionsLazyLoadingEnabled) {
                    this.logoutOfflineUserSessionByBrokerUserId(identityProviderAlias + "." + federatedUserId, identityProviderAlias + "." + sessionId);
                } else {
                    this.logoutOfflineUserSession(identityProviderAlias + "." + sessionId);
                }
            }
            if (userSession != null) {
                backchannelLogoutResponse.set(this.logoutUserSession(userSession));
            }
        });
        return backchannelLogoutResponse.get();
    }

    private void logoutOfflineUserSession(String brokerSessionId) {
        UserSessionModel offlineUserSession = this.session.sessions().getOfflineUserSessionByBrokerSessionId(this.realm, brokerSessionId);
        if (offlineUserSession != null) {
            new UserSessionManager(this.session).revokeOfflineUserSession(offlineUserSession);
        }
    }

    private BackchannelLogoutResponse backchannelLogoutFederatedUserId(String federatedUserId, Stream<String> identityProviderAliases, boolean logoutOfflineSessions) {
        BackchannelLogoutResponse backchannelLogoutResponse = new BackchannelLogoutResponse();
        backchannelLogoutResponse.setLocalLogoutSucceeded(true);
        identityProviderAliases.forEach(identityProviderAlias -> {
            if (logoutOfflineSessions) {
                this.logoutOfflineUserSessions(identityProviderAlias + "." + federatedUserId);
            }
            this.session.sessions().getUserSessionByBrokerUserIdStream(this.realm, identityProviderAlias + "." + federatedUserId).collect(Collectors.toList()).forEach(userSession -> {
                BackchannelLogoutResponse userBackchannelLogoutResponse = this.logoutUserSession((UserSessionModel)userSession);
                backchannelLogoutResponse.setLocalLogoutSucceeded(backchannelLogoutResponse.getLocalLogoutSucceeded() && userBackchannelLogoutResponse.getLocalLogoutSucceeded());
                userBackchannelLogoutResponse.getClientResponses().forEach(backchannelLogoutResponse::addClientResponses);
            });
        });
        return backchannelLogoutResponse;
    }

    private void logoutOfflineUserSessions(String brokerUserId) {
        UserSessionManager userSessionManager = new UserSessionManager(this.session);
        this.session.sessions().getOfflineUserSessionByBrokerUserIdStream(this.realm, brokerUserId).collect(Collectors.toList()).forEach(userSessionManager::revokeOfflineUserSession);
    }

    private void logoutOfflineUserSessionByBrokerUserId(String brokerUserId, String brokerSessionId) {
        UserSessionManager userSessionManager = new UserSessionManager(this.session);
        if (brokerUserId != null && brokerSessionId != null) {
            this.session.sessions().getOfflineUserSessionByBrokerUserIdStream(this.realm, brokerUserId).filter(userSession -> brokerSessionId.equals(userSession.getBrokerSessionId())).forEach(userSessionManager::revokeOfflineUserSession);
        }
    }

    private BackchannelLogoutResponse logoutUserSession(UserSessionModel userSession) {
        BackchannelLogoutResponse backchannelLogoutResponse = AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, false);
        if (backchannelLogoutResponse.getLocalLogoutSucceeded()) {
            this.event.user(userSession.getUser()).session(userSession).success();
        }
        return backchannelLogoutResponse;
    }

    private boolean oneOrMoreDownstreamLogoutsFailed(BackchannelLogoutResponse backchannelLogoutResponse) {
        BackchannelLogoutResponse filteredBackchannelLogoutResponse = new BackchannelLogoutResponse();
        for (BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse response : backchannelLogoutResponse.getClientResponses()) {
            if (!response.isWithBackchannelLogoutUrl()) continue;
            filteredBackchannelLogoutResponse.addClientResponses(response);
        }
        return backchannelLogoutResponse.getClientResponses().stream().filter(BackchannelLogoutResponse.DownStreamBackchannelLogoutResponse::isWithBackchannelLogoutUrl).anyMatch(clientResponse -> !clientResponse.getResponseCode().isPresent() || clientResponse.getResponseCode().get().intValue() != Response.Status.OK.getStatusCode() && clientResponse.getResponseCode().get().intValue() != Response.Status.NO_CONTENT.getStatusCode());
    }

    private void logout(UserSessionModel userSession, boolean offline) {
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, true, offline);
        this.event.user(userSession.getUser()).session(userSession).success();
    }

    private ClientModel authorizeClient() {
        ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors).getClient();
        this.cors.allowedOrigins(this.session, client);
        if (client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
        return client;
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkTokenIssuedAt(IDToken token, UserSessionModel userSession) throws OAuthErrorException {
        if (token.getIssuedAt() + 1 < userSession.getStarted()) {
            throw new OAuthErrorException("invalid_grant", "Refresh toked issued before the user session started");
        }
    }

    private Response initiateBrowserLogout(UserSessionModel userSession, String redirect, String state, String initiatingIdp) {
        if (redirect != null) {
            userSession.setNote("OIDC_LOGOUT_REDIRECT_URI", redirect);
        }
        if (state != null) {
            userSession.setNote("OIDC_LOGOUT_STATE_PARAM", state);
        }
        userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "openid-connect");
        logger.debug((Object)"Initiating OIDC browser logout");
        Response response = AuthenticationManager.browserLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, initiatingIdp);
        logger.debug((Object)"finishing OIDC browser logout");
        return response;
    }
}

