/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.OS;
import org.infinispan.server.test.core.ForkedInfinispanServerDriver;

public class ForkedServer {
    private static final Log log = LogFactory.getLog(ForkedInfinispanServerDriver.class);
    private static final String START_PATTERN = "ISPN080001";
    public static final int TIMEOUT_SECONDS = Integer.getInteger("org.infinispan.test.server.container.timeoutSeconds", 30);
    public static final Integer DEFAULT_SINGLE_PORT = 11222;
    public static final int OFFSET_FACTOR = 100;
    private final List<String> commands = new ArrayList<String>();
    private final String serverHome;
    private final String serverLogDir;
    private final String serverLog;
    private String jvmOptions;
    private String serverConfiguration;
    private final UUID serverId;
    private Process process;
    private Thread logMonitor;
    private final CountDownLatch isServerStarted = new CountDownLatch(1);

    public ForkedServer(String serverHome) {
        this.serverId = UUID.randomUUID();
        this.serverHome = serverHome;
        this.serverLogDir = serverHome + File.separator + "server" + File.separator + "log";
        this.serverLog = this.serverLogDir + File.separator + "server.log";
        this.cleanServerLog();
        this.callInitScript();
    }

    private void callInitScript() {
        String extension = OS.getCurrentOs() == OS.WINDOWS ? ".bat" : ".sh";
        this.commands.add(this.serverHome + File.separator + "bin" + File.separator + "server" + extension);
        this.addVmArgument(this.getClass().getName() + "-pid", this.serverId);
    }

    public ForkedServer setServerConfiguration(String serverConfiguration) {
        this.commands.add("-c");
        if (!new File(serverConfiguration).isAbsolute()) {
            serverConfiguration = this.getClass().getClassLoader().getResource(serverConfiguration).getPath();
        }
        this.serverConfiguration = serverConfiguration;
        this.commands.add(serverConfiguration);
        return this;
    }

    public ForkedServer setPortsOffset(int numServer) {
        if (numServer >= 1) {
            this.commands.add("-o");
            this.commands.add(String.valueOf(100 * numServer));
        }
        return this;
    }

    public ForkedServer setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public ForkedServer start() {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(this.commands);
        if (this.jvmOptions != null) {
            pb.environment().put("JAVA_OPTS", this.jvmOptions);
        }
        pb.redirectErrorStream(true);
        try {
            this.process = pb.start();
            this.logMonitor = new Thread(this.getServerMonitorRunnable(this.process.getInputStream()));
            this.logMonitor.start();
            if (!this.isServerStarted.await(TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
                throw new IllegalStateException(String.format("The server couldn't start within %d seconds!", TIMEOUT_SECONDS));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return this;
    }

    public Runnable getServerMonitorRunnable(InputStream outputStream) {
        return () -> {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(outputStream));
                while ((line = reader.readLine()) != null) {
                    log.info((Object)line);
                    if (!line.contains(START_PATTERN)) continue;
                    this.isServerStarted.countDown();
                }
                reader.close();
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
        };
    }

    public void stopInternal() {
        try {
            this.process.destroy();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        try {
            this.logMonitor.interrupt();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    private void cleanServerLog() {
        Exceptions.unchecked(() -> {
            Files.deleteIfExists(Paths.get(this.serverLog, new String[0]));
            boolean isServerLogDirectoryExist = Files.exists(Paths.get(this.serverLogDir, new String[0]), new LinkOption[0]);
            if (!isServerLogDirectoryExist) {
                Files.createDirectory(Paths.get(this.serverLogDir, new String[0]), new FileAttribute[0]);
            }
            Files.createFile(Paths.get(this.serverLog, new String[0]), new FileAttribute[0]);
        });
    }

    public File getServerLib() {
        return Paths.get(this.serverHome + File.separator + "server" + File.separator + "lib", new String[0]).toFile();
    }

    public long getPid() throws IllegalStateException {
        try {
            String jpsLine;
            Process jpsProcess = Runtime.getRuntime().exec(String.format("jps%s -v", OS.getCurrentOs() == OS.WINDOWS ? ".exe" : ""));
            BufferedReader input = new BufferedReader(new InputStreamReader(jpsProcess.getInputStream()));
            while ((jpsLine = input.readLine()) != null) {
                if (!jpsLine.contains(this.serverId.toString())) continue;
                jpsProcess.destroyForcibly();
                long pid = Long.parseLong(jpsLine.trim().split("\\s+")[0]);
                log.infof("Obtained pid is %d for process with UUID %s.", (Object)pid, (Object)this.serverId);
                return pid;
            }
            input.close();
            jpsProcess.destroyForcibly();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        throw new IllegalStateException("Unable to determine PID of the running Infinispan server.");
    }

    public String getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void addVmArgument(String key, Object value) {
        this.commands.add(String.format("-D%s=%s", key, value));
    }
}

