/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;

public class ChecksDeleteCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "delete"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        String string2 = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksDeleteCommandStep.checkFileArgExistence(string2, "checks settings");
        CheckSettingsConfigHelper checkSettingsConfigHelper = new CheckSettingsConfigHelper(string2);
        CheckSettingsConfig checkSettingsConfig = checkSettingsConfigHelper.read(ChecksDeleteCommandStep.listAllRules());
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        object = ((CommandScope)object).getConfiguredValue(CHECK_NAME_ARG).getValue();
        Object object2 = "cannot be deleted because it is a default check. Copies of default checks can be deleted.\nIf you don't want this check to run, try running 'liquibase checks disable '" + (String)object + "' instead.";
        Scope.getCurrentScope().getUI().sendMessage("Deleting check with short name ".concat(String.valueOf(object)));
        DynamicRule dynamicRule = checkSettingsConfig.getDynamicConfigurableRuleByShortName((String)object, (String)object2);
        if (dynamicRule == null) {
            throw new CommandExecutionException("Check '" + (String)object + "' does not exist." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks.");
        }
        if (!dynamicRule.isCopy()) {
            throw new CommandExecutionException("Check '" + (String)object + "' " + (String)object2);
        }
        if (dynamicRule.getParameters().isEmpty()) {
            throw new CommandExecutionException("Check '" + (String)object + "' does not have customization options." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        Scope.getCurrentScope().getUI().sendMessage("Current Customization Settings");
        Scope.getCurrentScope().getUI().sendMessage("Severity = " + (Object)((Object)dynamicRule.getSeverity()));
        for (DynamicRuleParameter dynamicRuleParameter : dynamicRule.getParameters()) {
            String string3 = dynamicRuleParameter.getParameterAsEnum().name();
            Object object3 = dynamicRuleParameter.getValue();
            Scope.getCurrentScope().getUI().sendMessage("Parameter name = ".concat(String.valueOf(string3)));
            Scope.getCurrentScope().getUI().sendMessage("Parameter value = " + (object3 == null ? "" : object3.toString()));
        }
        object2 = Scope.getCurrentScope().getUI().prompt(System.lineSeparator() + "Are you sure you want to delete " + (String)object + " ? (Y/N)", "N", (string, clazz) -> {
            if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return string;
        }, String.class);
        if (object2 != null && ((String)object2).equalsIgnoreCase("n")) {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        checkSettingsConfig.getRules().remove(dynamicRule);
        checkSettingsConfigHelper.write(checkSettingsConfig);
        Scope.getCurrentScope().getUI().sendMessage("Check " + (String)object + " deleted");
        Scope.getCurrentScope().getUI().sendMessage("Review the table below to confirm your changes.");
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Delete a check from the list of checks in this configuration");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to delete").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

