/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.dataconversion.xml.XStreamEngine;
import org.infinispan.server.core.logging.Log;

public class XMLTranscoder
extends OneToManyTranscoder {
    private static final Log logger = (Log)LogFactory.getLog(XMLTranscoder.class, Log.class);
    private final XStreamEngine xstream = new XStreamEngine();

    public XMLTranscoder() {
        this(XMLTranscoder.class.getClassLoader(), new ClassAllowList(Collections.emptyList()));
    }

    public XMLTranscoder(ClassAllowList classAllowList) {
        this(XMLTranscoder.class.getClassLoader(), classAllowList);
    }

    public XMLTranscoder(ClassLoader classLoader, ClassAllowList allowList) {
        super(MediaType.APPLICATION_XML, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_UNKNOWN});
        this.xstream.addPermission(NoTypePermission.NONE);
        this.xstream.addPermission(type -> allowList.isSafeClass(type.getName()));
        this.xstream.setClassLoader(classLoader);
    }

    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_XML)) {
            if (contentType.match(MediaType.APPLICATION_XML)) {
                return StandardConversions.convertCharset((Object)content, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
            }
            if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                String xmlString = this.xstream.toXML(content);
                return xmlString.getBytes(destinationType.getCharset());
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                String inputText = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                if (this.isWellFormed(inputText.getBytes())) {
                    return inputText.getBytes();
                }
                String xmlString = this.xstream.toXML(inputText);
                return xmlString.getBytes(destinationType.getCharset());
            }
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM) || contentType.match(MediaType.APPLICATION_UNKNOWN)) {
                String inputText = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                if (this.isWellFormed(inputText.getBytes())) {
                    return inputText.getBytes();
                }
                String xmlString = this.xstream.toXML(inputText);
                return xmlString.getBytes(destinationType.getCharset());
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM) || destinationType.match(MediaType.APPLICATION_UNKNOWN)) {
            return StandardConversions.convertTextToOctetStream((Object)content, (MediaType)contentType);
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertCharset((Object)content, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                Reader xmlReader = content instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
                return this.xstream.fromXML(xmlReader);
            }
            catch (ForbiddenClassException e) {
                throw logger.errorDeserializing(e.getMessage());
            }
            catch (XStreamException e) {
                throw new CacheException((Throwable)e);
            }
        }
        throw logger.unsupportedDataFormat(contentType);
    }

    private boolean isWellFormed(byte[] content) {
        boolean bl;
        block9: {
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            ConfigurationReader reader = ConfigurationReader.from((InputStream)is).build();
            try {
                while (reader.hasNext()) {
                    reader.nextElement();
                }
                bl = true;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }
}

