/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public final class Configuration {
    public static final char OPTION_PART_SEPARATOR_CHAR = '-';
    public static final String OPTION_PART_SEPARATOR = String.valueOf('-');

    private Configuration() {
    }

    public static synchronized SmallRyeConfig getConfig() {
        return (SmallRyeConfig)ConfigProviderResolver.instance().getConfig();
    }

    public static Optional<String> getBuildTimeProperty(String name) {
        Optional<String> value = Configuration.getRawPersistedProperty(name);
        if (value.isEmpty()) {
            value = Configuration.getRawPersistedProperty(Configuration.getMappedPropertyName(name));
        }
        if (value.isEmpty()) {
            String profile = Environment.getProfile();
            if (profile == null) {
                profile = Configuration.getConfig().getRawValue("kc.profile");
            }
            value = Configuration.getRawPersistedProperty("%" + profile + "." + name);
        }
        return value;
    }

    public static Optional<String> getRawPersistedProperty(String name) {
        return Optional.ofNullable(PersistedConfigSource.getInstance().getValue(name));
    }

    public static String getRawValue(String propertyName) {
        return Configuration.getConfig().getRawValue(propertyName);
    }

    public static Iterable<String> getPropertyNames() {
        return Configuration.getConfig().getPropertyNames();
    }

    public static ConfigValue getConfigValue(String propertyName) {
        return Configuration.getConfig().getConfigValue(propertyName);
    }

    public static Optional<String> getOptionalValue(String name) {
        return Configuration.getConfig().getOptionalValue(name, String.class);
    }

    public static Optional<Boolean> getOptionalBooleanValue(String name) {
        return Configuration.getConfig().getOptionalValue(name, String.class).map(new Function<String, Boolean>(){

            @Override
            public Boolean apply(String s) {
                return Boolean.parseBoolean(s);
            }
        });
    }

    public static String getMappedPropertyName(String key) {
        PropertyMapper mapper = PropertyMappers.getMapper(key);
        if (mapper == null) {
            return key;
        }
        return mapper.getTo() == null ? mapper.getFrom() : mapper.getTo();
    }

    public static Optional<String> getRuntimeProperty(String name) {
        for (ConfigSource configSource : Configuration.getConfig().getConfigSources()) {
            if ("PersistedConfigSource".equals(configSource.getName())) continue;
            String value = Configuration.getValue(configSource, name);
            if (value == null) {
                value = Configuration.getValue(configSource, Configuration.getMappedPropertyName(name));
            }
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static String toEnvVarFormat(String key) {
        return StringUtil.replaceNonAlphanumericByUnderscores((String)key).toUpperCase();
    }

    public static String toCliFormat(String key) {
        return "--" + key;
    }

    private static String getValue(ConfigSource configSource, String name) {
        String value = configSource.getValue(name);
        if (value == null) {
            value = configSource.getValue("%".concat(Environment.getProfileOrDefault("prod").concat(".").concat(name)));
        }
        return value;
    }
}

